﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EcmaScript.NET;
using Yahoo.Yui.Compressor;

namespace Curse.MSBuild.Packer
{
    public class YuiErrorReporter : CustomErrorReporter
    {
        public YuiErrorReporter(bool isVerboseLogging)
            : base(isVerboseLogging ? (LoggingType.Debug | LoggingType.Info) : LoggingType.None) { }

        public override void Error(string message, string sourceName, int line, string lineSource, int lineOffset)
        {
            throw new InvalidOperationException(
                string.Format("[ERROR] {0} ******** Source: {1}. Line: {2}. LineSource: {3}. LineOffset: {4}",
                              message,
                              sourceName,
                              line,
                              lineSource,
                              lineOffset));
        }
    }
}
