﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.MSBuild.WebFarmDeployTester
{
    public static class DatabaseManager
    {
        public static void CreateDatabaseLogins(string clusterNumber, string environment)
        {
            
            string databaseClusterName = "sql" + clusterNumber + "-" + environment;
            var createPermissionsSql = FileHelper.GetLocalFileContents(@"Scripts\CreateDatabaseLogins.sql")
                .Replace("{node-name}", databaseClusterName);;

            foreach (var letter in Constants.NodeLetters)
            {
                using (SqlConnection conn = new SqlConnection(@"Server=sql" + clusterNumber + letter + @"-live.curse.us\instance01;Database=master;Integrated Security=SSPI;MultipleActiveResultSets=True;MultiSubnetFailover=True;"))
                {
                    conn.Open();
                    SqlCommand cmd = conn.CreateCommand();
                    cmd.CommandText = createPermissionsSql;
                    try
                    {
                        cmd.ExecuteNonQuery();
                        Console.WriteLine("Succcess");
                    }
                    catch (Exception ex)
                    {
                        if (ex.Message.Contains("exists"))
                        {
                            Console.WriteLine(ex.Message);
                        }
                        else
                        {
                            throw;
                        }
                    }
                    
                }

            }
           
        }


        public static void SetupDatabasePermissions(string clusterNumber, string environment, string databaseName)
        {
            string databaseClusterName = "sql" + clusterNumber + "-" + environment;
            var createPermissionsSql = FileHelper.GetLocalFileContents(@"Scripts\CreatePermissions.sql");
            createPermissionsSql = createPermissionsSql.Replace("{node-name}", databaseClusterName);

            var resetPermissionSql = FileHelper.GetLocalFileContents(@"Scripts\ResetPermissions.sql");
            resetPermissionSql = resetPermissionSql.Replace("{node-name}", databaseClusterName);

            string connectionString = "Server=tcp:" + databaseClusterName + ",1433;Database=" + databaseName + ";Integrated Security=SSPI;;MultipleActiveResultSets=True;Max Pool Size=1024;MultiSubnetFailover=True;";

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                conn.Open();
                var cmd = conn.CreateCommand();

                cmd.CommandText = resetPermissionSql;
                try
                {
                    cmd.ExecuteNonQuery();
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.Message);
                }

                try
                {

                    cmd.CommandText = createPermissionsSql;
                    cmd.ExecuteNonQuery();
                }                
                catch (Exception ex)
                {
                    Console.WriteLine(ex.Message);
                }

            }

        }

        private static string GetInstanceName(string clusterNumber, string nodeLetter, string environment)
        {
            return "sql" + clusterNumber + nodeLetter + "-" + environment + @"\instance01";
        }

        public static void SetupReadOnlyReplica(string clusterNumber, string environment)
        {
           string listener = "sql" + clusterNumber + "-" + environment;

           Console.WriteLine("Setting up read only replicas for: " + listener);

            string[] nodeLetters = new string[] {"a", "b", "c"};
            Dictionary<string, string> nodeLetterToUrl = new Dictionary<string, string>();
            string baseRoutingUrlSql = FileHelper.GetLocalFileContents(@"Scripts\ReadOnlyRoutingUrl.sql");
            string baseRoutingListSql = FileHelper.GetLocalFileContents(@"Scripts\ReadOnlyRoutingList.sql");
            string primaryReplica = null;
            string overallSql = "";

            List<string> databaseNames = new List<string>();
            Console.Write("Getting list of databases on this server... ");
            using (SqlConnection conn = new SqlConnection( "Server=" + listener + ";Database=master;Integrated Security=SSPI;MultipleActiveResultSets=True;MultiSubnetFailover=True;"))
            {
                conn.Open();
                var cmd = conn.CreateCommand();
                cmd.CommandText = "SELECT name FROM sys.databases where owner_sid > 0x01";
                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        databaseNames.Add(reader.GetString(0));
                    }
                }

                cmd.CommandText = "select primary_replica from sys.dm_hadr_availability_group_states";
                primaryReplica = (string)cmd.ExecuteScalar();
            }
            Console.WriteLine("Done");

            foreach (var nodeLetter in nodeLetters)
            {
                string sqlInstance = GetInstanceName(clusterNumber, nodeLetter, environment);
                Console.Write("Getting read only replica URL for " + sqlInstance + "... ");
                try
                {
                    
                    var replicaUrl = GetReadonlyReplicaUrl(sqlInstance);
                    nodeLetterToUrl.Add(nodeLetter, sqlInstance);
                    var sql = baseRoutingUrlSql.Replace("{ag-listener}", listener)
                                .Replace("{ag-instance}", sqlInstance)
                                .Replace("{ag-url}", replicaUrl);

                    overallSql = overallSql + Environment.NewLine + "--Node " + nodeLetter;
                    overallSql = overallSql + Environment.NewLine + sql + Environment.NewLine;
                    Console.WriteLine("Done");
                }
                catch (Exception ex)
                {
                    Console.WriteLine("Failed: " + ex.Message);
                    return;
                }
                
            }
            
            overallSql = overallSql + Environment.NewLine;

            foreach (var nodeLetter in nodeLetters)
            {
                string[] otherNodeUrls = nodeLetterToUrl.Where(p => p.Key != nodeLetter).Select(p => "'" + p.Value + "'").ToArray();
                string sqlInstance = GetInstanceName(clusterNumber, nodeLetter, environment);
                var sql = baseRoutingListSql.Replace("{ag-listener}", listener)
                           .Replace("{ag-instance}", sqlInstance)
                           .Replace("{ag-instance-list}", string.Join(",", otherNodeUrls));

                overallSql = overallSql + Environment.NewLine + "--Node " + nodeLetter;
                overallSql = overallSql + Environment.NewLine + sql + Environment.NewLine;
            }

            string connectionString = "Server=" + listener + ";Database=master;Integrated Security=SSPI;MultipleActiveResultSets=True;MultiSubnetFailover=True;";


            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                Console.Write("Setting up routing rules... ");

                try
                {
                    conn.Open();
                    var cmd = conn.CreateCommand();
                    cmd.CommandText = overallSql;
                    cmd.ExecuteNonQuery();
                }
                catch (Exception ex)
                {
                    Console.WriteLine("Failed: " + ex.Message);
                    return;
                    
                }

                Console.WriteLine("Done");
            }

            // Get a list of all databases on this server:
            Console.WriteLine("-------------------------------------------------------------------------------------------------------------------");
            Console.WriteLine("Testing readonly connectivity to all databases.");
            foreach (var databaseName in databaseNames)
            {
                Console.Write("Testing readonly connection to '" + databaseName + "'... ");
                string readOnlyConnString = "Server=tcp:" + listener + ",1433;Database=" + databaseName + ";Integrated Security=SSPI;MultipleActiveResultSets=True;MultiSubnetFailover=True;ApplicationIntent=ReadOnly;";
                using (SqlConnection conn = new SqlConnection(readOnlyConnString))
                {
                    try
                    {
                        conn.Open();
                        var cmd = conn.CreateCommand();
                        cmd.CommandText = "SELECT SERVERPROPERTY('ServerName')";
                        string connectedServerName = (string)cmd.ExecuteScalar();
                        if (connectedServerName.Equals(primaryReplica, StringComparison.InvariantCultureIgnoreCase))
                        {
                            Console.ForegroundColor = ConsoleColor.Red;
                            Console.WriteLine("Failed: Connection routed to master, instead of replica.");
                            Console.ResetColor();
                        }
                        else
                        {
                            Console.ForegroundColor = ConsoleColor.Green;
                            Console.WriteLine("Success: Connected to replica '" + connectedServerName + "'");
                            Console.ResetColor();
                        }
                        
                    }
                    catch (Exception ex)
                    {
                        Console.ForegroundColor = ConsoleColor.Red;
                        Console.WriteLine("Failed: " + ex.Message);
                        Console.ResetColor();
                    }
                    
                }
            }
            Console.WriteLine("All databases have been tested.");
            Console.WriteLine("-------------------------------------------------------------------------------------------------------------------");
            

        }

        public static string GetReadonlyReplicaUrl(string nodeName)
        {
            var sql = FileHelper.GetLocalFileContents(@"Scripts\GetReadOnlyReplicaUrl.sql");
            sql = sql.Replace("{node-name}", nodeName);

            string connectionString = "Server=" + nodeName + ";Database=master;Integrated Security=SSPI;;MultipleActiveResultSets=True;Max Pool Size=1024;MultiSubnetFailover=True;";

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                conn.Open();
                var cmd = conn.CreateCommand();
                cmd.CommandText = sql;
                return (string)cmd.ExecuteScalar();
            }
        }
    }
}
