﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.MSBuild.WebFarmDeployTester
{
    internal static class FileHelper
    {
        public static FileInfo GetLocalFileInfo(string relativeFilePath)
        {
            string currentDirectory = AppDomain.CurrentDomain.BaseDirectory;
            FileInfo fi = new FileInfo(Path.Combine(currentDirectory, relativeFilePath));

            if (!fi.Exists)
            {
                throw new
                 Exception("No file at: " + fi.FullName);
            }

            return fi;
        }

        public static string GetLocalFileContents(string relativePath)
        {
            var fileInfo = GetLocalFileInfo(relativePath);
            using (var reader = new StreamReader(fileInfo.FullName))
            {
                return reader.ReadToEnd();
            }
        }
    }
}
