﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Runtime.Remoting.Channels;
using System.Text;
using System.Threading.Tasks;
using Curse.MSBuild.Deployment;
using System.IO;
using System.Diagnostics;
using System.Net;
using Microsoft.Web.Administration;
using System.Threading;
using Curse.MSBuild.Chef;

namespace Curse.MSBuild.WebFarmDeployTester
{
    public class Program
    {
        
        static void Main(string[] args)
        {
            GetSiteBindings("Vox", "iis35a-live.curse.us");
            return;





            string[] VirginiaWorkerNodes = { "worker01a-iad.curse.us", "worker01b-iad.curse.us", "worker02a-iad.curse.us", "worker02b-iad.curse.us", "worker03a-iad.curse.us", "worker03b-iad.curse.us", };
            string[] VirginiaNorificationNodes = { "svc01a-iad.curse.us", "svc01b-iad.curse.us", "svc02a-iad.curse.us", "svc02b-iad.curse.us", "svc03a-iad.curse.us", "svc03b-iad.curse.us", "svc04a-iad.curse.us", "svc04b-iad.curse.us", "svc05a-iad.curse.us", "svc05b-iad.curse.us", "svc06a-iad.curse.us", "svc06b-iad.curse.us" };
            string[] VirginiaGroupNodes = { "group01a-iad.curse.us", "group01b-iad.curse.us"  };
            
            string[] DublinNotificationNodes = { "scv02a-dub.curse.us", "svc01a-dub.curse.us", "svc01b-dub.curse.us", "svc02b-dub.curse.us", "svc03a-dub.curse.us", "svc03b-dub.curse.us" };
            string[] DublinWorkerNodes = { "worker01a-dub.curse.us", "worker01b-dub.curse.us", "worker02a-dub.curse.us", "worker02b-dub.curse.us", "worker03a-dub.curse.us", "worker03b-dub.curse.us" };
            string[] DublinGroupNodes = { "group01a-dub.curse.us", "group01b-dub.curse.us" };
            
            string[] SingaporeNotificationHosts = { "svc01a-sin", "svc01b-sin" };
            string[] SingaporeWorkerNodes = { "worker01a-sin.curse.us", "worker01b-sin.curse.us", };
            string[] SingaporeGroupNodes = { "group01a-sin.curse.us", "group01b-sin.curse.us" };

            return;
           
            //ZipHelper.CopyZipToTemp(@"C:\Windows\Temp\Deploys\StatsService\1-0-5892-25598\HealthCheck.zip", "svc108a-iad.curse.io", "1-0-5892-25598");
            //DeployFriendsNotificationService();
            //return;
            
            //DeployWindowsService();
            //return;
                
            //ReconfigureAllAppPools("live", true);

            //return;
            //DeployConsoleApplication();
            //return;
            

            //TestHostFile();

            //DeployApplicationHostConfig();

            //;
            
           //DeployCobaltApplication();
           //return;
             
            
            //DatabaseManager.SetupDatabasePermissions("sql07-live", "AuthenticationService");

            switch (args[0])
            {
                case "deploy-health":
                    if (args.Length > 1)
                    {
                        int groupNumber;
                        if (int.TryParse(args[1], out groupNumber))
                        {
                            DeployHealthMonitorToGroup(groupNumber);
                        }
                        else
                        {
                            Console.WriteLine("Invalid group number!");
                            return;                            
                        }
                    }
                    else
                    {
                        DeployHealthMonitorToAllNodes();    
                    }
                    
                    break;

                case "normalize-recyles":
                    WebNodeManager.NormalizeRecycleTimes(args[1], args[2], args[3], int.Parse(args[4]), int.Parse(args[5]));
                    break;

                case "db-logins":
                    DatabaseManager.CreateDatabaseLogins(args[1], args[2]);
                    break;

                case "db-permissions":
                    DatabaseManager.SetupDatabasePermissions(args[1], args[2], args[3]);
                    break;
                    
                case "db-replica":
                    DatabaseManager.SetupReadOnlyReplica(args[1], args[2]);
                    break;

                case "reboot":
                    WebNodeManager.RebootNodes(args[1], args[2]);
                    break;

                case "reset-iis":
                    WebNodeManager.ResetIIS(args[1], args[2]);
                    break;

                case "execute-command":
                    WebNodeManager.CopyFile(int.Parse(args[1]), args[2], @"\\iis23b-live.curse.us\c$\Windows\System32\Drivers\etc\hosts", @"c$\windows\system32\drivers\etc\hosts");
                    break;
                case "test-cobalt-deploy":
                    DeployCobaltApplication();
                    break;
                case "friends-notification":
                    DeployFriendsNotificationService();
                    break;                    
                case "friends-worker":
                    DeployFriendsWorkerService();
                    break;
                case "friends-jobs":
                    DeployFriendsJobService();
                    break;
                default:
                    Console.WriteLine("Unknown Command: " + args[0]);
                    break;

            }

            

            Console.WriteLine("All Done!");
        }

        private static void StopWindowsService(string environment, string nodeTag, string serviceName)
        {
            var nodes = SousChef.GetWindowsNodesForService(environment, nodeTag);
            foreach (var node in nodes)
            {
                using (var runspace = RemoteScriptHelper.CreateRunspace(node.Name))
                {
                    RemoteScriptHelper.StopService(runspace, serviceName);
                }
            }
        }

        private static void ReconfigureAllAppPools(string environment, bool autoCommit)
        {
            for (int i = 1; i <= Constants.TotalNodes; i++)
            {
                foreach (var letter in Constants.NodeLetters)
                {
                    string serverName = "iis" + i.ToString("00") + letter + "-" + environment;
                    Console.WriteLine("Reconfiguring app pool on '" + serverName + "'... ");
                    if (ReconfigureAppPool("iis" + i.ToString("00") + letter + "-" + environment))
                    {
                        if (autoCommit)
                        {
                            Console.Write("Sleeping 15 seconds...");
                            Thread.Sleep(TimeSpan.FromSeconds(15));
                            Console.WriteLine("Done");
                        }
                        else
                        {
                            DeployUtils.PromptUser("Press ENTER to continue...", new[] { ConsoleKey.Enter });
                        }
                       
                    }
                }
            }
        }

        private static bool ReconfigureAppPool(string serverName)
        {
            using (var serverManager = ServerManager.OpenRemote(serverName))
            {
                ApplicationPool applicationPool = serverManager.ApplicationPools.FirstOrDefault(p => !string.IsNullOrEmpty(p.ManagedRuntimeVersion) && !p.Name.Contains("HealthMonitor"));
                if (applicationPool != null)
                {
                    Console.Write("Found app pool: " + applicationPool.Name + ", Managed Version: " + applicationPool.ManagedRuntimeVersion + ". Configuring... ");
                    WebAdminHelper.ConfigureAppPool(serverName, serverManager, applicationPool.Name, true, applicationPool.ManagedRuntimeVersion, true);
                    Console.WriteLine("Done");
                    return true;
                }
                else
                {
                    Console.WriteLine("No app pool found, skipping.");
                    return false;
                }
            }
        }

        private static void TestHostFile()
        {
            var hostFile = HostFile.Parse();

            hostFile.AddOrReplaceEntry("www.gamepedia.com", "10.105.12.9");
            hostFile.Save();

            hostFile.RemoveEntry("www.test.com");
            hostFile.Save();
        }


        private static void DeployConsoleApplication()
        {
            var deploy = new ConsoleAppDeploy();
            deploy.ApplicationName = "YttriumScanner";
            deploy.ApplicationSourcePath = @"C:\publish\YttriumScanner\1-0-5003-40596";
            deploy.ApplicationVersion = "1-0-5003-40596";
            deploy.ServerNames = new[] { "runner03a-live" };
            deploy.Execute();
        }


        private static void DeployCurseVoiceUpdateService()
        {
            var ipList = new List<string>();
            using (var conn = new SqlConnection("Data Source=sql07-live.curse.us;Initial Catalog=CurseVoice;Integrated Security=True;MultiSubnetFailover=true"))
            {
                conn.Open();
                using (var cmd = conn.CreateCommand())
                {
                    cmd.CommandText = "SELECT [IPAddress] from [VoiceHost]";

                    using (var reader = cmd.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            var ipAddress = reader.GetString(0);                            
                            ipList.Add(ipAddress);
                        }
                    }
                }
            }

            var deploy = new WindowsServiceDeploy();
            deploy.DestinationDriveLetter = "C";
            deploy.DestinationFolderPath = @"Program Files\CurseVoiceUpdateService";
            deploy.ApplicationName = "CurseVoiceUpdater";
            deploy.TempFolderPath = @"C:\Publish\CurseVoiceUpdateService";
            deploy.ApplicationSourcePath = @"C:\Projects\Radium\Curse.Voice\Curse.Voice.UpdateService\bin\Release";
            deploy.ApplicationVersion = "1-0-0-0";
            deploy.ServerNames = ipList.ToArray();
            deploy.ServerNames = new[] { "54.207.65.20" };
            deploy.Username = "curse";
            deploy.Password = GetPassword();
            deploy.Execute();
        }

        private static void DeployFriendsNotificationService()
        {
            var deploy = new AuthenticatedWindowsServiceDeploy();            
            deploy.ApplicationName = "CurseNotificationService";            
            deploy.ApplicationSourcePath = @"C:\Projects\CloudServices\Source\Curse.Friends.NotificationService\bin\Release";
            deploy.ApplicationVersion = "1-0-0-0";
            deploy.ApplicationExecutableFileName = "Curse.Friends.NotificationService.exe";
            deploy.ConfirmCommitToSecondaries = true;
            deploy.ServerFilteringPrompt = true;

            deploy.ServerNames = GetServerNames(new[]
            {
                "svc01a-iad.curse.us", "svc01b-iad.curse.us", "svc02a-iad.curse.us", "svc02b-iad.curse.us", "svc03a-iad.curse.us", "svc03b-iad.curse.us", // North America
                "svc01a-dub.curse.us", "svc01b-dub.curse.us", "svc02a-dub.curse.us", "svc02b-dub.curse.us", "svc03a-dub.curse.us", "svc03b-dub.curse.us", // Europe
                "svc01a-sin.curse.us", "svc01b-sin.curse.us" // Asia
            });
            
            deploy.Execute();
        }

        private static string[] GetServerNames(string[] allServerNames)
        {
            var res = DeployUtils.PromptUser("Do you want to limit this deploy to a specific region? ([N]A, [E]U, [A]P, or ENTER for all )", new[] { ConsoleKey.Enter, ConsoleKey.N, ConsoleKey.E, ConsoleKey.A });

            Console.WriteLine("Limit this deploy to a specific node number? (Enter a node number)");
            var nodeNumberVal = Console.ReadLine();

            int nodeNumber;
            if (!string.IsNullOrEmpty(nodeNumberVal) && int.TryParse(nodeNumberVal, out nodeNumber))
            {
                
                allServerNames = allServerNames.Where(p => p.Contains(nodeNumber.ToString("00"))).ToArray();
            }

            switch (res)
            {
                case ConsoleKey.N:
                    return allServerNames.Where(p => p.Contains("iad")).ToArray();                    
                case ConsoleKey.E:
                    return allServerNames.Where(p => p.Contains("dub")).ToArray();                    
                case ConsoleKey.A:
                    return allServerNames.Where(p => p.Contains("sin")).ToArray();
                default:
                    return allServerNames;
            }
        }

        private static void DeployFriendsWorkerService()
        {
            var deploy = new AuthenticatedWindowsServiceDeploy();
            deploy.ApplicationName = "CurseWorkerService";
            deploy.ApplicationSourcePath = @"C:\Projects\CloudServices\Source\Curse.Friends.WorkerService\bin\Release";
            deploy.ApplicationVersion = "1-0-0-0";            
            deploy.ApplicationExecutableFileName = "Curse.Friends.WorkerService.exe";
            deploy.ServerNames =  GetServerNames(new[] { "worker01a-iad", "worker01b-iad", "worker02a-iad", "worker02b-iad", "worker01a-dub", "worker01b-dub", "worker02a-dub", "worker02b-dub", "worker01a-sin", "worker01b-sin" });            
            deploy.Execute();
        }

        private static void DeployFriendsJobService()
        {
            var deploy = new AuthenticatedWindowsServiceDeploy();
            deploy.ApplicationName = "CurseJobService";
            deploy.ApplicationSourcePath = @"C:\Projects\CloudServices\Source\Curse.Friends.JobService\bin\Release";
            deploy.ApplicationVersion = "1-0-0-0";
            deploy.ApplicationExecutableFileName = "Curse.Friends.JobService.exe";
            deploy.ServerNames = new[] { "job01a-iad"};
            deploy.Execute();
        }


        private static void DeployWindowsFirewallRules()
        {
            var ipList = new List<string>();
            using (var conn = new SqlConnection("Data Source=sql07-live.curse.us;Initial Catalog=CurseVoice;Integrated Security=True;MultiSubnetFailover=true"))
            {
                conn.Open();
                using (var cmd = conn.CreateCommand())
                {
                    cmd.CommandText = "SELECT [IPAddress] from [VoiceHost]";

                    using (var reader = cmd.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            var ipAddress = reader.GetString(0);
                            ipList.Add(ipAddress);
                        }
                    }
                }
            }

            var deploy = new WindowsServerFirewallDeploy();                        
            
            deploy.Ports = new[] {3784, 6100, 9987, 10011};
            deploy.ServerNames = ipList.ToArray();
            deploy.ServerNames = new[] { "162.242.238.46" };
            deploy.Username = "curse";
            deploy.Password = GetPassword();
            deploy.Execute();
        }

        private static string GetPassword()
        {
            Console.Write("Enter the password: ");
            return Console.ReadLine();
        }


        private static void DeployCobaltApplication()
        {

            string currentDirectory = Directory.GetCurrentDirectory();
            FileInfo configFile = new FileInfo(Path.Combine(currentDirectory, @"ConfigurationTemplates\StaticSiteConfig.config"));

            var deploy = new WebFarmDeploy();
            deploy.WebNodeNames = new[] { "iis01a-dev.curse.us" };
            deploy.ApplicationName = "Titanium";
            deploy.ApplicationVersion = "1-0-5276-22210";
            deploy.FileServerName = "smb01a-hsv.curse.us";
            deploy.StaticFolderPath = @"C:\publish\Titanium\1-0-5276-22210\TitaniumStatic\1-0-5276-22210";
            deploy.WebAppFolderPath = @"C:\publish\Titanium\1-0-5276-22210\TitaniumWebCompiled\1-0-5276-22210";            
            deploy.CopyAppFiles = true;
            deploy.CreateWebSites = true;
            deploy.SiteBindings = new[] { "www.reignofgaming.local", "" };
            
            // Static Site
            deploy.StaticConfigPath = configFile.FullName;
            deploy.CopyStaticFiles = true;
            deploy.CreateStaticSites = true;
            deploy.CopyStaticToCurrent = true;
            deploy.StaticSiteBinding = "static-titanium.cursecdn.local";

            // Media Site            
            deploy.CreateMediaSites = true;
            deploy.MediaSiteBinding = "media-titanium.cursecdn.local";
            deploy.MediaApplicationPath = @"\\smb01a-hsv.curse.us\CobaltMedia\Titanium";
            deploy.MediaNodeNames = new[] {"iis01a-dev.curse.us"};


            // Options
            deploy.AutoCommit = true;
            deploy.Commit = true;
            deploy.CleanupAfterDeploy = true;
            deploy.NotifyNewRelic = false;
            

            // Notification Settings
            deploy.SendNotificationEmail = true;
            deploy.SmtpServerHost = "mandrill.curse.com";
            deploy.SmtpServerPassword = "syVRRVZ-9EA569_mU2Xw8A";
            deploy.SmtpServerUsername = "mcomperda@curse.com";
            deploy.NotificationEmailRecipient = "rmuzzey@curse.com";
            deploy.NotificationEmailBody = "This is a test, please ignore";
            deploy.NotificationEmailSubject = deploy.ApplicationName + " Live Deploy - Version " + deploy.ApplicationVersion;
            deploy.NotificationEmailSender = @"noreply@curse.com";
            deploy.NotificationEmailSuccessBody = "The deploy to " + deploy.ApplicationName + " has completed successfully. It is now safe to resume using the site.";
            var result = deploy.Execute();

            Console.WriteLine("-------------------------------------------------------");

            if (result)
            {
                Console.WriteLine("The deploy has completed successfully!");
            }
            else
            {
                Console.WriteLine("The deploy failed to complete successfully!");
            }
            
            Console.WriteLine("Press any key to exit.");
            Console.ReadKey(true);
        }

        private static void DeployHealthMonitorToAllNodes()
        {
            foreach (var nodeLetter in Constants.NodeLetters.ToArray())
            {
                // Deploy to the zone
                for (int i = 1; i <= Constants.TotalNodes; i++)
                {
                    string nodeName = "iis" + i.ToString("00") + nodeLetter + "-live.curse.us";
                    Console.Title = "Deploying Health Monitor to Zone " + nodeLetter + ", Node " + i + " of " + Constants.TotalNodes.ToString();
                    DeployHealthMonitorToNode(nodeName);
                }
              
            }
        }

        private static void DeployHealthMonitorToGroup(int groupNumber)
        {
            DeployHealthMonitorToGroup(groupNumber, Constants.NodeLetters.ToArray());
        }

        public static void DeployHealthMonitorToGroup(int groupNumber, string[] nodeLetters)
        {
            foreach (var nodeLetter in nodeLetters)
            {
                // Deploy to the zone                
                string nodeName = "iis" + groupNumber.ToString("00") + nodeLetter + "-live.curse.us";
                Console.Title = "Deploying Health Monitor to Zone " + nodeLetter;
                DeployHealthMonitorToNode(nodeName);
            }
        }

        private static void DeployHealthMonitorToNode(string nodeName)
        {
            var deploy = new WebFarmDeploy();
            deploy.WebNodeNames = new[] { nodeName };
            deploy.ApplicationName = "HealthMonitor";
            deploy.ApplicationVersion = "";
            deploy.SkipApplicationPoolRecycle = true;
            deploy.SkipUpdateSitePath = true;
            deploy.WebAppZipPath = @"C:\publish\HealthMonitor.zip";
            deploy.StaticZipPath = "";
            deploy.SiteBindings = new[] { "health-check.curse.us" };
            deploy.CreateWebSites = true;
            deploy.CopyAppFiles = true;
            deploy.CopyStaticFiles = false;
            deploy.AutoCommit = true;
            deploy.DisableBindingValidation = true;
            deploy.SendNotificationEmail = false;
            bool success = deploy.Execute();
            if (!success)
            {
                Console.WriteLine("Failed!");
                return;
            }

            HttpWebRequest webRequest = (HttpWebRequest)WebRequest.Create("http://" + nodeName);
            webRequest.UserAgent = "googlebot (Curse Health Monitor)";
            webRequest.Proxy = null;
            webRequest.Host = "health-check.curse.us";

            try
            {
                WebResponse resp = webRequest.GetResponse();
                Console.WriteLine("Health check returned a valid response.");

            }
            catch (WebException e)
            {
                using (WebResponse response = e.Response)
                {
                    HttpWebResponse httpResponse = (HttpWebResponse)response;
                    Console.WriteLine("Error code: {0}", httpResponse.StatusCode);
                    using (Stream data = response.GetResponseStream())
                    {
                        using (var reader = new StreamReader(data))
                        {
                            string text = reader.ReadToEnd();

                            if (text.Contains("Health monitor was unable to auto-detect the host to monitor"))
                            {
                                if (DeployUtils.PromptUser("The health monitor on " + nodeName + " was unable to detect what site to monitor on this node. Do you wish to continue anyways?", new[] { ConsoleKey.Y, ConsoleKey.N }) == ConsoleKey.N)
                                {
                                    return;
                                }
                            }
                            else
                            {
                                Console.WriteLine("This health check has failed: " + text + ". Press any key to abort the health check deploy process.");
                                Console.ReadKey();
                                return;
                            }
                        }
                    }
                }
            }


            Console.WriteLine("Done with " + nodeName);
        }

        private static void DeployApplicationHostConfig()
        {
            string currentDirectory = Directory.GetCurrentDirectory();
            FileInfo configFile = new FileInfo(Path.Combine(currentDirectory, "applicationHost.config"));


            for (int i = 31; i <= Constants.TotalNodes; i++)
            {
                Console.Title = "Deploying Application Host to Cluster " + i + " of " + Constants.TotalNodes.ToString();
                string[] destinationNodes = new[] { "iis" + i.ToString("00") + "a-live.curse.us", "iis" + i.ToString("00") + "b-live.curse.us", "iis" + i.ToString("00") + "c-live.curse.us", };

                foreach (string destinationNode in destinationNodes)
                {
                    string unc = string.Format(@"\\{0}\c$\windows\system32\inetsrv\config\applicationHost.config", destinationNode);
                    configFile.CopyTo(unc, true);
                }
                Console.WriteLine("Done with cluster #" + i.ToString("00"));
            }
        }

        public static void GetSiteBindings(string siteName, string node)
        {
            using (var runspace = RemoteScriptHelper.CreateRunspace(node))
            {
                var existingBindings = new HashSet<string>(
                    RemoteScriptHelper.ExecuteRemoteScriptDynamic(runspace, string.Format(@"(Get-Website ""{0}"").Bindings.Collection", siteName), false).Select(binding => (string)binding.bindingInformation));

                foreach(var binding in existingBindings)
                {
                    Console.WriteLine(binding);
                }
            }
        }
    }
}
