﻿using Curse.MSBuild.Deployment;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Curse.MSBuild.WebFarmDeployTester
{
    public static class WebNodeManager
    {
        public static void RebootNodes(string clusterNumber, string environment)
        {
            foreach (var nodeLetter in Constants.NodeLetters)
            {
                string nodeName = "iis" + clusterNumber + nodeLetter + "-" + environment;
                ExecuteRemoteCommand(nodeName, "shutdown /r /t 00");                
            }            
        }

        public static void ResetIIS(string clusterNumber, string environment)
        {
            foreach (var nodeLetter in Constants.NodeLetters)
            {
                string nodeName = "iis" + clusterNumber + nodeLetter + "-" + environment;
                ExecuteRemoteCommand(nodeName, "iisreset");
            }
        }

        public static void NormalizeRecycleTimes(string clusterNumber, string environment, string applicationName, int additionalMinutes, int recyclesPerDay = 24, int delay = 120)
        {
            foreach (var nodeLetter in Constants.NodeLetters)
            {
                string nodeName = "iis" + clusterNumber + nodeLetter + "-" + environment;
                Console.WriteLine("Normalizing recycles times on '" + nodeName + "'");
                WebAdminHelper.SetRecycleTimes(nodeName, applicationName, additionalMinutes, true, "v4.0", recyclesPerDay);
                Thread.Sleep(TimeSpan.FromSeconds(delay));
            }
        }

        public static void CopyFile(int maxNode, string environment, string fileSource, string fileDestination)
        {
            FileInfo fi = new FileInfo(fileSource);
            foreach (var nodeLetter in Constants.NodeLetters)
            {
                for (int i = 1; i <= maxNode; i++)
                {
                    string nodeName = "iis" + i.ToString("00") + nodeLetter + "-" + environment  + ".curse.us";
                    Console.Write("Copying to " + nodeName + "... ");
                    try
                    {
                        fi.CopyTo(@"\\" + nodeName + @"\" + fileDestination, true);
                        Console.WriteLine("Done");
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine("Failed: " + ex.Message);
                    }
                    
                  
                }
            }
        }

        public static void ExecuteRemoteCommand(string computerName, string command)
        {           
            Process p = new Process();

            p.StartInfo.FileName = @"C:\Program Files (x86)\PsExec\psexec.exe";
            p.StartInfo.Arguments = string.Format(@"/accepteula -s -h -n 10 \\{0} {1}", computerName, command);
            p.StartInfo.UseShellExecute = false;
            p.StartInfo.RedirectStandardOutput = true;
            p.Start();
            p.WaitForExit();
            
        }

        

    }
}
