jQuery(function($) {
    $("body").append('<div id="kBox" style="left:0;top:0;"><div id="kBox_shadow"><div id="kBox_container" class="box"><ul class="label" id="kBox_header"><li id="kBox_caption" class="title">&nbsp;</li></ul><div id="kBox_content"></div><div id="kBox_response"></div></div></div></div>');
});
function kBoxLoadObject() {
    this.loading = $("#kBox_load");
}

kBoxLoadObject.prototype.load;
kBoxLoadObject.prototype.show = function() {
    this.position();
    this.loading.show();
};
    
kBoxLoadObject.prototype.hide = function() {
    this.loading.hide();
};
    
kBoxLoadObject.prototype.position = function() {
    var hs = Geometry.getHorizontalScroll();
    var vw = Geometry.getViewportWidth(); 
    var vs = Geometry.getVerticalScroll();
    var vh = Geometry.getViewportHeight(); 
    return this.loading.css({left: (hs +(vw - 100)/2), top:(vs+(vh-100)/2)});        
};

function kBoxOverlayObject() {
    this.overlay = $("#kBox_overlay");
    this.loading = new kBoxLoadObject();
}

kBoxOverlayObject.prototype.loading;
kBoxOverlayObject.prototype.overlay;
kBoxOverlayObject.prototype.show = function(show_loading) {
    this.size();
    // hack to get the ads to not overlay the lightbox
    $('#container').css('display', 'none');
    this.overlay.show();
    if (show_loading) this.loading.show();
};
    
kBoxOverlayObject.prototype.hide = function() {
    //if (this.loading.css('display') == "block") this.loading.hide();
    this.overlay.hide();    
    $('#container').css('display', 'block');
};
    
kBoxOverlayObject.prototype.size = function() {
    this.overlay.css({"height": Geometry.getDocumentHeight(), "width": Geometry.getDocumentWidth()});
};

function kBoxObject(persist) {
    this.wrapper = $("#kBox");
    this.overlay = new kBoxOverlayObject();
    this.container = $("#kBox_container");
    this.content = $("#kBox_content");
    this.caption = $("#kBox_caption");
    this.header = $('#kBox_header');
    
    this.invisPotion = { filter: 'alpha(opacity=0)', '-moz-opacity': '0', opacity: '0'};
    this.visPotion = { filter: 'alpha(opacity=100)', '-moz-opacity': '1', opacity: '1'};
    
    //nasty hack due to stupid oo implementations
    var obj = this;
    function func() { return obj.hide() }
    this.overlay.overlay.click(func);
    
    if (!persist) {
        this.clear_links();
        this.content.empty();
        this.caption.empty();
    }
}

kBoxObject.prototype.wrapper;
kBoxObject.prototype.content;
kBoxObject.prototype.overlay;
kBoxObject.prototype.caption;
kBoxObject.prototype.links;
kBoxObject.prototype.invisPotion;
kBoxObject.prototype.visPotion;
kBoxObject.prototype.size;
kBoxObject.prototype.clear_links = function()
{
    $('li[@rel=deleteme]', this.header).remove();
    this.header.append("<li rel='deleteme'><a id='kBoxClose' href='javascript:void(0);' class='button'><span>Close</span></a></li>");
    var obj = this;
    function func() { return obj.hide() }
    $("#kBoxClose").click(func);
}
kBoxObject.prototype.show = function(leaveLoading) {
    this.position();
    this.wrapper.css({visibility: 'visible'});
    if (!leaveLoading) {
        this.makeVis();
        this.overlay.loading.hide();
    }
    
    //nasty hack due to stupid oo implementations
    var obj = this;
    function func() { obj.position() }
    //$(window).scroll(func).resize(func);
};
    
kBoxObject.prototype.hide = function() {
    this.wrapper.css({visibility: 'hidden'});
    this.overlay.hide();
    $(window).unbind('scroll').unbind('resize');
    this.makeInvis();
    return false;
};

kBoxObject.prototype.makeInvis = function() {
    this.wrapper.css(this.invisPotion);
};

kBoxObject.prototype.makeVis = function() {
    this.wrapper.css(this.visPotion);
};

kBoxObject.prototype.fadeIn = function(speed) {
    this.makeVis();
    this.wrapper.fadeIn(speed);
    this.overlay.loading.loading.fadeOut(speed);
};

kBoxObject.prototype.size = function(width, height) {
    if (!width && !height) {
        var width = Geometry.getViewportWidth() * .8;
        var height = Geometry.getViewportHeight() * .8;
        this.autoSize();
    }
    this.wrapper.css({width: width, height: height});
};

kBoxObject.prototype.autoSize = function() {
    $(window).resize(this.size);
};
    
kBoxObject.prototype.position = function() {
    var hs = Geometry.getHorizontalScroll();
    var vw = Geometry.getViewportWidth();
    var width = parseInt(this.wrapper.css('width'));
    var vs = Geometry.getVerticalScroll();
    var vh = Geometry.getViewportHeight();
    var height = parseInt(this.wrapper.css('height'));
    this.wrapper.css({left: (hs +(vw - width)/2), top:(vs+(vh-height)/2)});
};

kBoxObject.prototype.addClickHide = function(target) {
    //nasty hack due to stupid oo implementations
    var obj = this;
    function func() { obj.hide() }
    target.click(func)
};

kBoxObject.prototype.load = function(url, params, callback) {
    //nasty hack due to stupid oo implementations
    var obj = this;
    function func() {
        obj.show();
        
        if (callback) {
            callback();
        }
    }
    this.content.load(url, params, func);
};

kBoxObject.prototype.insert = function(content) {    
    //nasty hack due to stupid oo implementations
    var obj = this;
    function func() { return obj.hide() }
    
    $('a[@rel*=close]', content).click(func);
    
    $(content).appendTo(this.content);
};
    
kBoxObject.prototype.image = function(url, caption) {
    //nasty hack due to stupid oo implementations
    var obj = this;
    
    this.content.empty();    
    
    this.makeInvis();
    
    this.size(100, 100);
    this.show(true);
    
    function show() {
    
        var width = img.width();
        var height = img.height();
        
        obj.size(width+42, height+62);
        obj.position();
        
        obj.fadeIn()
        
        function zoom75() {
            img.attr({width: width*.75, height:height*.75});    
            obj.size(width*.75+42, height*.75+62);
            obj.position();
            return false;
        }
        
        function zoom100() {
            img.attr({width: width, height:height});    
            obj.size(width+42, height+62);
            obj.position();
            return false;
        }
            
        function zoom150() {
            img.attr({width: width*1.5, height:height*1.5});    
            obj.size(width*1.5+42, height*1.5+62);
            obj.position();
            return false;
        }
        obj.header.append($("<li rel='deleteme'><a href='javascript:void(0);' class='button'><span>150%</span></a></li>").click(zoom150));
        obj.header.append($("<li rel='deleteme'><a href='javascript:void(0);' class='button'><span>100%</span></a></li>").click(zoom100));
        obj.header.append($("<li rel='deleteme'><a href='javascript:void(0);' class='button'><span>75%</span></a></li>").click(zoom75));     
        img.unbind('load');
    }
    var img = $("<img src='"+url+"'/>").load(show).appendTo($('<div class="stuff"></div>').appendTo(this.content));

    function hide() { return obj.hide() }
    
    img.click(hide);
    
    if (caption) {
        this.caption.html(caption);
    } else {
        var bits = url.split(/\//);
        this.caption.html(bits[bits.length-1]);
    }
};

function kBox_Image(url, caption) {
    var box = new kBoxObject();
    //box.overlay.show(true);
    box.image(url, caption);
}

function kBox_Ajax(width, height, caption, url, params, callback) {
    var box = new kBoxObject();
    //box.overlay.show(true);
    box.size(width, height);
    box.load(url, params, callback);
    box.caption.html(caption);
}

function kBox_Content(width, caption, content, adjust, hide) {
    var box = new kBoxObject();
    //box.overlay.show(true);
    box.caption.html(caption);
    box.insert(content);
    box.size(width, 0);
    
    box.size(width, box.container.height()+22);
    box.position();

    box.show();
    
    // will add a click hide to the content.  
    if (hide) {
        box.addClickHide(content);
    }
    return box;
}

function kBox_Preview(e, caption, url, params) {
    if (!e) var e = window.event;
    var button = e.target ? e.target : e.srcElement;
    $(button).val('Loading Preview...').attr('disabled', 'disabled');
    func = function() {
        var box = new kBoxObject(true);
        var height = box.container.height();
        if (height > 500) height = 500;
        box.size(650, height+22);
        box.position();
        box.content.css('overflow-y', 'auto')
        box.content.css('overflow-x', 'none')
        $(button).val('Preview').attr('disabled', '');
    }
    kBox_Ajax(650, 0, caption, url, params, func);
}

function kBox_ImageUpload() {
    kBox_Ajax(550, 400, "Image Upload", '/images/ajax-submit')    
}

function kBox_TagsPop(org_url){
    
    var options = { 
        success:       showResponse,  // post-submit callback
        beforeSubmit:  showRequest
    }; 
     
    // post-submit callback 
    function showResponse(responseText, statusText)  {
        $("#kBox_content").html(responseText);
        tagsPopPrep();
    }
    
    function showRequest() {
        var input = $("#add_tag_form input.button");
        var color = input.is('.dark') ? 'dark' : 'grey';
        input.after('<span class="busy"><img src="http://static.curse-gaming.com/images/busy_' + color + '.gif" alt="Busy..." style="width: 16px; height:16px;" /> Busy...</span>');
        input.css('display', 'none');
        
        return true;
    }
    
    function tagsPopPrep() {
        //$('#add_tag_form').ajaxForm(options);
        // Disabled until Bryan fixes it
        /*$('#id_tag').autocomplete('/js/tags/', {
            minChars: 2,
            delay: 100,
            formatItem: function(row){
                return '<span class="ct fr">' + row[1] + '</span>' + row[0];
            }
        });*/
        
        
        var target = $('#add_tag_form').attr('action')
        
        $('a', '#kBox_content').each(function(){
            var href = $(this).attr('href');
            if (href)
            {
                if (href.match("/[^/]+/([^/]+)/([^/]+)/([^/]+)/([^/]+)/([^/]+)/")) {
                    var info = href.match("/[^/]+/([^/]+)/([^/]+)/([^/]+)/([^/]+)/([^/]+)/");
                
                    $(this).click(function (){
                        showRequest();
                        $.post(target, {action: info[4], target: info[5]}, function(response) {
                            showResponse(response, "success");
                        });
                    
                        return false;
                    });
                }
            }
        });
        
        $("#add_tag_form").submit(function() {
            showRequest();
            $.post(target, {action:"add", target: $('#id_tag').val() }, function(response) {
                showResponse(response, "success");
            });
            
            return false;
        });
        
        window.setTimeout("$('div[@rel=msg]', '#kBox_content').hide('slow')", 2000);
        
        var box = new kBoxObject(true);
        var content = box.content;
        var adjHeight = 50
        content.children().each(function(){
            adjHeight = adjHeight + $(this).height();
        });
        box.size(550, adjHeight);
    }
    
    kBox_Ajax(550, 310, "Manage Tags", org_url + 'ajax/', {}, tagsPopPrep);
}

function kBox_BookmarkPop() {
    kBox_Ajax(550, 400, "Select Bookmark Provider", "/bookmark")
}