﻿using System;
using Curse.ServiceUpdate.WebClient.UpdateWebService;

namespace Curse.ServiceUpdate.Deployment
{
    public class UpdateCoordinatorCallback : IUpdateDeployerCallback
    {
        public VerifyCommitRequest VerifyCommit(UpdateCompleteNotification request)
        {
            Console.Write("Deploy to {0} {1}. Do you want to continue the deploy? [Y]/[N]: ", request.Host,
                request.Success ? "succeeded" : "failed");

            while (true)
            {
                var key = Console.ReadKey().Key;
                switch (key)
                {
                    case ConsoleKey.Y:
                        Console.WriteLine();
                        return new VerifyCommitRequest { ContinueDeploy = true };
                    case ConsoleKey.N:
                        Console.WriteLine();
                        return new VerifyCommitRequest { ContinueDeploy = false };
                }
            }
        }

        public void NotifyUpdateComplete(UpdateCompleteNotification request)
        {
            Console.WriteLine("Deploy to {0} {1}. Continuing.", request.Host, request.Success ? "succeeded" : "failed");
        }
    }
}
