﻿using System;
using System.Configuration;
using System.Diagnostics;
using System.ServiceProcess;
using Curse.ServiceUpdate.WebClient;
using Curse.ServiceUpdate.WebClient.UpdateWebService;

namespace Curse.ServiceUpdate.Tester
{
    partial class CurseUpdaterTestService : ServiceBase
    {
        public CurseUpdaterTestService()
        {
            InitializeComponent();
        }

        protected override void OnStart(string[] args)
        {
            RegisterWithCentral();
        }

        protected override void OnStop()
        {
            // Unregister?
        }

        private void RegisterWithCentral()
        {
            try
            {
                var response = UpdateCoordinatorHelper.RegisterHost(UpdateEnvironment.Debug, ConfigurationManager.AppSettings["ApiKey"], new RegisterHostBody
                {
                    Host = Environment.MachineName,
                    ServiceName = ServiceName,
                });
                if (response.Status != RegisterStatus.Success)
                {
                    Debugger.Break();
                }
            }
            catch (Exception)
            {
                Debugger.Break();
                throw;
            }
        }


        public void OnDebugStart()
        {
            OnStart(null);
        }

        public void OnDebugStop()
        {
            OnStop();
        }
    }
}
