﻿using System;
using System.IO;
using System.ServiceModel;

namespace Curse.ServiceUpdate.UpdateManagement.Messages
{
    public class PushRequestBody
    {
        public string ServiceName { get; set; }

        public Version ServiceVersion { get; set; }

        public bool InstallIfMissing { get; set; }

        public string BaseInstallLocation { get; set; }

        public byte[] ZipStream { get; set; }
    }

    [MessageContract]
    public class PushRequestMessage
    {
        [MessageHeader(MustUnderstand = true)]
        public byte[] InitializationVector { get; set; }

        [MessageBodyMember]
        public Stream EncryptedBody { get; set; }
    }
}
