﻿using System.IO;
using System.Runtime.Serialization;
using System.ServiceModel;

namespace Curse.ServiceUpdate.UpdateManagement.Messages
{
    [DataContract]
    public enum PushStatus
    {
        [EnumMember]
        Error,

        [EnumMember]
        Success,
    }

    public class PushResponseBody
    {
        public UpdateStatus Status { get; set; }

        public string StatusMessage { get; set; }
    }

    [MessageContract]
    public class PushResponseMessage
    {
        [MessageHeader(MustUnderstand = true)]
        public byte[] InitializationVector { get; set; }

        [MessageBodyMember]
        public byte[] EncryptedBody { get; set; }
    }
}
