﻿using System.IO;
using System.Runtime.Serialization;
using System.ServiceModel;

namespace Curse.ServiceUpdate.UpdateManagement.Messages
{
    [DataContract]
    public enum UpdateStatus
    {
        [EnumMember]
        Error,

        [EnumMember]
        Success,
    }

    public class UpdateResponseBody
    {
        public UpdateStatus Status { get; set; }

        public string StatusMessage { get; set; }
    }

    [MessageContract]
    public class UpdateResponseMessage
    {
        [MessageHeader(MustUnderstand = true)]
        public byte[] InitializationVector { get; set; }

        [MessageBodyMember]
        public byte[] EncryptedBody { get; set; }
    }
}
