﻿using System.IO;
using System.Runtime.Serialization;
using System.ServiceModel;

namespace Curse.ServiceUpdate.UpdateManagement.Messages
{
    [DataContract]
    public enum UploadStatus
    {
        [EnumMember]
        Error,

        [EnumMember]
        Success
    }

    public class UploadResponseBody
    {
        public UploadStatus Status { get; set; }

        public string StatusMessage { get; set; }
    }

    [MessageContract]
    public class UploadResponseMessage
    {
        [MessageHeader(MustUnderstand = true)]
        public byte[] InitializationVector { get; set; }

        [MessageBodyMember]
        public byte[] EncryptedBody { get; set; }
    }
}
