﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Runtime.Serialization;
using System.Security.Cryptography;
using System.Security.Cryptography.X509Certificates;

namespace Curse.ServiceUpdate.UpdateManagement.Security
{
    public class Encryption
    {
        public static EncryptedDataPair Encrypt(byte[] input, byte[] key)
        {
            using (var aes = new AesManaged())
            {
                aes.Mode = CipherMode.CBC;
                aes.Key = key;
                return new EncryptedDataPair
                {
                    InitializationVector = aes.IV,
                    EncryptedData = aes.CreateEncryptor().TransformFinalBlock(input, 0, input.Length)
                };
            }
        }

        public static EncryptedDataPair EncryptData<T>(T obj, byte[] key)
        {
            using (var ms = new MemoryStream())
            {
                var dcSerializer = new DataContractSerializer(typeof (T));
                dcSerializer.WriteObject(ms, obj);
                return Encrypt(ms.ToArray(), key);
            }
        }

        public static byte[] GenerateKey()
        {
            using (var aes = new AesManaged())
            {
                aes.KeySize = 256;
                aes.BlockSize = 128;
                aes.Mode = CipherMode.CBC;
                return aes.Key;
            }
        }

        public static byte[] DecryptKey(byte[] encryptedKey, X509Certificate2 certificate)
        {
            var provider = (RSACryptoServiceProvider) certificate.PrivateKey;
            return provider.Decrypt(encryptedKey, false);
        }

        public static byte[] EncryptKey(byte[] plainKey, X509Certificate2 certificate)
        {
            var rsaPublicKey = (RSACryptoServiceProvider) certificate.PublicKey.Key;
            RSAPKCS1KeyExchangeFormatter keyFormatter = new RSAPKCS1KeyExchangeFormatter(rsaPublicKey);
            return keyFormatter.CreateKeyExchange(plainKey, typeof(AesManaged));
        }

        public static void Decrypt(Stream input, byte[] key, byte[] iv, Stream output)
        {
            using (var aes = new AesManaged())
            {
                aes.Key = key;
                aes.IV = iv;
                using (var m = new MemoryStream())
                {
                    using (var crypto = new CryptoStream(m, aes.CreateDecryptor(), CryptoStreamMode.Write))
                    {
                        input.CopyTo(crypto);
                    }
                    var bytes = m.ToArray();
                    output.Write(bytes, 0, bytes.Length);
                }
            }
        }

        public static T Decrypt<T>(Stream input, byte[] key, byte[] iv)
        {
            using (var ms = new MemoryStream())
            {
                var dcSerializer = new DataContractSerializer(typeof (T));
                Decrypt(input, key, iv, ms);
                ms.Position = 0;
                return (T) dcSerializer.ReadObject(ms);
            }
        }

        public static T Decrypt<T>(byte[] input, byte[] key, byte[] iv)
        {
            using (var inputStream = new MemoryStream(input))
            {
                return Decrypt<T>(inputStream, key, iv);
            }
        }
    }
}
