﻿using System;
using System.Diagnostics;
using System.IO;
using System.Runtime.Serialization;
using System.Security.Cryptography.X509Certificates;
using System.ServiceModel;
using System.Text;
using Curse.ServiceUpdate.UpdateManagement.Messages;
using Curse.ServiceUpdate.UpdateManagement.Security;

namespace Curse.ServiceUpdate.UpdateManagement
{
    public class UpdateListenerClient : TcpClientBase<IUpdateListener>
    {
        public static UpdateListenerClient Create(string address, int port, X509Certificate2 certificate, string apiKey)
        {
            var client = new UpdateListenerClient(address, port);
            client.Handshake(certificate, apiKey);
            return client;
        }

        public static UpdateListenerClient Create(string address, int port, X509Certificate2 certificate, string apiKey, IUpdaterSeedCallback callback, byte[] callbackKey)
        {
            var client = new UpdateListenerClient(address, port);
            client.Handshake(certificate, apiKey, callback, callbackKey);
            return client;
        }

        private UpdateListenerClient(string address, int port)
            : base(address, port, "update-service")
        {
        }

        public PushResponseBody PushUpdate(PushRequestBody request)
        {
            var pair = Encryption.EncryptData(request, EncryptionKey);
            using (var ms = new MemoryStream(pair.EncryptedData))
            {
                var response = Channel.PushUpdate(new PushRequestMessage
                {
                    InitializationVector = pair.InitializationVector,
                    EncryptedBody = ms
                });

                return Encryption.Decrypt<PushResponseBody>(response.EncryptedBody, EncryptionKey,
                    response.InitializationVector);
            }
        }
    }
}
