﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.Threading.Tasks;
using Curse.ServiceUpdate.UpdateManagement.Messages;
using Curse.ServiceUpdate.UpdateManagement.Security;

namespace Curse.ServiceUpdate.UpdateManagement
{
    class UpdaterSeedCallback : IUpdaterSeedCallback
    {
        private readonly X509Certificate2 _certificate;
        internal byte[] EncryptionKey;

        public UpdaterSeedCallback(X509Certificate2 certificate)
        {
            _certificate = certificate;
        }

        public GetKeyResponse GetKey(GetKeyRequest request)
        {
            var body = Encryption.Decrypt<GetKeyRequestBody>(request.EncryptedBody, EncryptionKey, request.InitializationVector);
            var response = new GetKeyResponseBody
            {
                Key = Encryption.DecryptKey(body.EncryptedKey, _certificate)
            };

            var pair = Encryption.EncryptData(response, EncryptionKey);
            return new GetKeyResponse
            {
                InitializationVector = pair.InitializationVector,
                EncryptedBody = pair.EncryptedData
            };
        }
    }
}
