﻿using System.IO;
using System.Security.Cryptography.X509Certificates;
using Curse.ServiceUpdate.UpdateManagement.Messages;
using Curse.ServiceUpdate.UpdateManagement.Security;

namespace Curse.ServiceUpdate.UpdateManagement
{
    public class UpdaterSeedClient : TcpClientBase<IUpdaterSeed>
    {
        public static UpdaterSeedClient Create(string address, int port, X509Certificate2 certificate, string apiKey)
        {
            var callback = new UpdaterSeedCallback(certificate);
            var client = new UpdaterSeedClient(address, port, callback);
            client.Handshake(certificate, apiKey);
            callback.EncryptionKey = client.EncryptionKey;
            return client;
        }

        private UpdaterSeedClient(string address, int port, UpdaterSeedCallback callback)
            : base(address, port, "update-seed", callback)
        {

        }

        public UploadResponseBody UploadUpdate(UploadRequestBody request)
        {
            var pair = Encryption.EncryptData(request, EncryptionKey);
            using (var ms = new MemoryStream(pair.EncryptedData))
            {
                var response = Channel.UploadUpdate(new UploadRequestMessage
                {
                    InitializationVector = pair.InitializationVector,
                    EncryptedBody = ms
                });

                return Encryption.Decrypt<UploadResponseBody>(response.EncryptedBody, EncryptionKey,
                    response.InitializationVector);
            }
        }

        public UpdateResponseBody UpdateService(UpdateRequestBody request)
        {
            var pair = Encryption.EncryptData(request, EncryptionKey);
            using (var ms = new MemoryStream(pair.EncryptedData))
            {
                var response = Channel.UpdateService(new UpdateRequestMessage
                {
                    InitializationVector = pair.InitializationVector,
                    EncryptedBody = ms
                });

                return Encryption.Decrypt<UpdateResponseBody>(response.EncryptedBody, EncryptionKey,
                    response.InitializationVector);
            }
        }
    }
}
