﻿using System;
using System.Configuration;
using System.Diagnostics;
using System.IO;
using System.Xml.Serialization;

namespace Curse.ServiceUpdate.UpdateService.Configuration
{
    public enum ConfigurationMode
    {
        Debug,
        Staging,
        Release,
        LoadTesting
    }


    [XmlType("UpdateService")]
    public class UpdateServiceConfiguration
    {
        public static ConfigurationMode Mode { get; private set; }

        private static readonly UpdateServiceConfiguration _instance = null;

        public static UpdateServiceConfiguration Instance
        {
            get { return _instance; }
        }

        static UpdateServiceConfiguration()
        {

#if CONFIG_DEBUG
            Mode = ConfigurationMode.Debug;
#elif CONFIG_STAGING
            Mode = ConfigurationMode.Staging;
#elif CONFIG_RELEASE
            Mode = ConfigurationMode.Release;
#elif CONFIG_LOADTESTING
            Mode = ConfigurationMode.LoadTesting;
#endif
            // Try to load the config, based on the compilation mode
            string configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Configuration", "UpdateService." + Mode + ".config");

            if (!File.Exists(configPath))
            {
                throw new ConfigurationErrorsException("Configuration could not be loaded from '" + configPath + "'");
            }

            using (StreamReader reader = new StreamReader(configPath))
            {
                XmlSerializer dcs = new XmlSerializer(typeof(UpdateServiceConfiguration));
                try
                {
                    _instance = (UpdateServiceConfiguration)dcs.Deserialize(reader);
                }
                catch (Exception ex)
                {
                    Debug.WriteLine("Failed to read config file: " + ex.Message);
                    throw;
                }

            }

        }

        [XmlElement()]
        public string ApiKey { get; set; }

        [XmlElement()]
        public int ListenerPortNumber { get; set; }

        [XmlElement()]
        public string LocalInstallPath { get; set; }

        [XmlElement]
        public string UpdateStorePath { get; set; }

        [XmlElement]
        public string LogServiceUrl { get; set; }
    }
}
