﻿using System;
using System.ServiceModel;
using System.ServiceProcess;
using Curse.Logging;
using Curse.Logging.Uploader;
using Curse.ServiceUpdate.UpdateService.Configuration;

namespace Curse.ServiceUpdate.UpdateService
{
    partial class CurseUpdateService : ServiceBase
    {
        public CurseUpdateService()
        {
            InitializeComponent();
        }

        private ServiceHost _updaterServiceHost;

        protected override void OnStart(string[] args)
        {            
            Logger.Init(@"C:\Curse\Logs");
            LogUploader.Initialize(15, UpdateServiceConfiguration.Instance.LogServiceUrl, UpdateServiceConfiguration.Instance.ApiKey);

            Logger.Info("Starting Update Service");

            _updaterServiceHost = new ServiceHost(typeof(UpdaterService));
            _updaterServiceHost.Open();

            Logger.Info("Update Service Started");
        }

        protected override void OnStop()
        {
            Logger.Info("Stopping Update Service");
            if (_updaterServiceHost != null)
            {
                _updaterServiceHost.Close(TimeSpan.FromSeconds(5));                
            }
            Logger.Info("Update Service Stopped");
            LogUploader.Shutdown();
        }

        public void OnDebug()
        {
            OnStart(null);

        }

        public void OnDebugStop()
        {
            OnStop();
        }
    }
}
