﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.ServiceUpdate.UpdateManagement;
using Curse.ServiceUpdate.UpdateManagement.Messages;
using Curse.ServiceUpdate.UpdateManagement.Security;

namespace Curse.ServiceUpdate.UpdateListener
{
    public class UpdaterSeedCallback : IUpdaterSeedCallback
    {
        private readonly IUpdaterSeedCallback _callback;
        private readonly byte[] _callbackEncryptionKey;

        public UpdaterSeedCallback(IUpdaterSeedCallback callback, byte[] encryptionKey)
        {
            _callback = callback;
            _callbackEncryptionKey = encryptionKey;
        }

        public byte[] GetDecryptedKeyFromCallback(byte[] encryptedKey)
        {
            var pair = Encryption.EncryptData(new GetKeyRequestBody {EncryptedKey = encryptedKey}, _callbackEncryptionKey);
            using (var ms = new MemoryStream(pair.EncryptedData))
            {
                var response = GetKey(new GetKeyRequest
                {
                    InitializationVector = pair.InitializationVector,
                    EncryptedBody = ms
                });

                return Encryption.Decrypt<GetKeyResponseBody>(response.EncryptedBody, _callbackEncryptionKey,
                    response.InitializationVector).Key;
            }
        }

        public GetKeyResponse GetKey(GetKeyRequest request)
        {
            return _callback.GetKey(request);
        }
    }
}
