﻿using System;
using System.Configuration;
using System.Diagnostics;
using System.IO;
using System.Xml.Serialization;
using Curse.ServiceUpdate.WebService.Data;

namespace Curse.ServiceUpdate.WebService.Configuration
{
    [XmlType("Coordinator")]
    public class CoordinatorConfiguration
    {
        public static EnvironmentType Mode { get; private set; }

        private static readonly CoordinatorConfiguration _instance = null;

        public static CoordinatorConfiguration Instance
        {
            get { return _instance; }
        }

        static CoordinatorConfiguration()
        {

#if CONFIG_DEBUG
            Mode = EnvironmentType.Debug;
#elif CONFIG_STAGING
            Mode = EnvironmentType.Staging;
#elif CONFIG_RELEASE
            Mode = EnvironmentType.Release;
#elif CONFIG_LOADTESTING
            Mode = EnvironmentType.LoadTesting;
#endif
            // Try to load the config, based on the compilation mode
            string configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Configuration", "Coordinator." + Mode + ".config");

            if (!File.Exists(configPath))
            {
                throw new ConfigurationErrorsException("Configuration could not be loaded from '" + configPath + "'");
            }

            using (StreamReader reader = new StreamReader(configPath))
            {
                XmlSerializer dcs = new XmlSerializer(typeof(CoordinatorConfiguration));
                try
                {
                    _instance = (CoordinatorConfiguration)dcs.Deserialize(reader);
                }
                catch (Exception ex)
                {
                    Debug.WriteLine("Failed to read config file: " + ex.Message);
                    throw;
                }

            }

        }

        [XmlElement()]
        public string ApiKey { get; set; }

        [XmlElement()]
        public string DatabaseConnectionString { get; set; }

        [XmlElement]
        public string CertificateThumbprint { get; set; }

        [XmlElement]
        public string LogServiceUrl { get; set; }
    }
}
