﻿using System;
using System.Data.SqlClient;

namespace Curse.ServiceUpdate.WebService.Data
{
    public class CurseService
    {
        public int ID { get; private set; }
        public string ServiceName { get; set; }
        public string BaseInstallPathOverride { get; set; }

        public CurseService()
        {
            
        }

        private CurseService(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            ServiceName = reader.GetString(1);
            BaseInstallPathOverride = reader.IsDBNull(2) ? null : reader.GetString(2);
        }

        public void SaveToDatabase()
        {
            using (var conn = DatabaseHelper.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    command.Parameters.AddWithValue("@ServiceName", ServiceName);
                    command.Parameters.AddWithValue("@BaseInstallPathOverride", string.IsNullOrEmpty(BaseInstallPathOverride) ? DBNull.Value : (object) BaseInstallPathOverride);
                    if (ID == 0)
                    {
                        command.CommandText = "INSERT INTO [CurseService] (ServiceName, BaseInstallPathOverride) OUTPUT INSERTED.ID VALUES(@ServiceName, @BaseInstallPathOverride)";
                        ID = (int) command.ExecuteScalar();
                    }
                    else
                    {
                        command.CommandText = "UPDATE [CurseService] SET ServiceName = @ServiceName, BaseInstallPathOverride = @BaseInstallPathOverride WHERE ID = @ID";
                        command.Parameters.AddWithValue("@ID", ID);
                        command.ExecuteNonQuery();
                    }
                }
            }
        }

        public static CurseService GetByID(int id)
        {
            using (var conn = DatabaseHelper.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [CurseService] WHERE ID = @ID";
                    command.Parameters.AddWithValue("@ID", id);

                    using (var reader = command.ExecuteReader())
                    {
                        return reader.Read() ? new CurseService(reader) : null;
                    }
                }
            }
        }

        public static CurseService GetByName(string serviceName)
        {
            using (var conn = DatabaseHelper.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [CurseService] WHERE ServiceName = @ServiceName";
                    command.Parameters.AddWithValue("@ServiceName", serviceName);

                    using (var reader = command.ExecuteReader())
                    {
                        return reader.Read() ? new CurseService(reader) : null;
                    }
                }
            }
        }

    }
}