﻿using System;
using System.Data.SqlClient;
using Curse.ServiceUpdate.WebService.Configuration;

namespace Curse.ServiceUpdate.WebService.Data
{
    public static class DatabaseHelper
    {
        private static readonly string ConnectionString = CoordinatorConfiguration.Instance.DatabaseConnectionString;

        public static SqlConnection GetConnection(string connectionString = null)
        {
            connectionString = connectionString ?? ConnectionString;

            var connection = new SqlConnection(connectionString);
            connection.Open();
            using (var cmd = connection.CreateCommand())
            {
                cmd.CommandText = "SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;";
                cmd.ExecuteNonQuery();
            }
            return connection;
        }

        public static DateTime GetDateTimeUtc(this SqlDataReader reader, int ordinal)
        {
            return DateTime.SpecifyKind(reader.GetDateTime(ordinal), DateTimeKind.Utc).ToUniversalTime();
        }
    }
}