﻿using System.Collections.Concurrent;
using System.Data.SqlClient;

namespace Curse.ServiceUpdate.WebService.Data
{
    public class UpdatePayload
    {
        public int ID { get; private set; }

        public int ServiceID { get; set; }

        public int VersionID { get; set; }

        public byte[] Data { get; set; }

        public UpdatePayload()
        {
            
        }

        private UpdatePayload(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            ServiceID = reader.GetInt32(1);
            VersionID = reader.GetInt32(2);
            Data = (byte[]) reader["Data"];
        }

        public void SaveToDatabase()
        {
            using (var conn = DatabaseHelper.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    command.Parameters.AddWithValue("@Data", Data);

                    if (ID == 0)
                    {
                        command.Parameters.AddWithValue("@ServiceID", ServiceID);
                        command.Parameters.AddWithValue("@VersionID", VersionID);
                        command.CommandText = "INSERT INTO [UpdatePayload] (ServiceID, VersionID, Data) OUTPUT INSERTED.ID VALUES(@ServiceID, @VersionID, @Data)";
                        ID = (int) command.ExecuteScalar();
                    }
                    else
                    {
                        command.Parameters.AddWithValue("@ID", ID);
                        command.CommandText = "Update [UpdatePayload] SET Data = @Data WHERE ID = @ID";
                        command.ExecuteNonQuery();
                    }

                }
            }
        }

        private static readonly ConcurrentDictionary<int, UpdatePayload> PayloadsByID = new ConcurrentDictionary<int, UpdatePayload>(); 

        public static UpdatePayload GetByServiceAndVersion(int serviceID, int versionID)
        {
            UpdatePayload payload;
            if (PayloadsByID.TryGetValue(versionID, out payload))
            {
                return payload;
            }

            using (var conn = DatabaseHelper.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [UpdatePayload] WHERE ServiceID = @ServiceID AND VersionID = @VersionID";
                    command.Parameters.AddWithValue("@ServiceID", serviceID);
                    command.Parameters.AddWithValue("@VersionID", versionID);

                    using (var reader = command.ExecuteReader())
                    {
                        if (reader.Read())
                        {
                            payload = new UpdatePayload(reader);
                            PayloadsByID.TryAdd(versionID, payload);
                            return payload;
                        }
                    }
                }
            }

            return null;
        }
    }
}