﻿using System.Collections.Generic;
using System.Data.SqlClient;

namespace Curse.ServiceUpdate.WebService.Data
{
    public enum UpdateTargetStatus
    {
        Pending,
        Running,
        Canceled,
        Failed,
        Completed
    }

    public class UpdateTarget
    {
        public int ID { get; private set; }
        public int JobID { get; set; }
        public int ServiceHostID { get; set; }
        public int RegionID { get; set; }
        public UpdateTargetStatus Status { get; set; }

        public UpdateTarget()
        {
            
        }

        private UpdateTarget(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            JobID = reader.GetInt32(1);
            ServiceHostID = reader.GetInt32(2);
            RegionID = reader.GetInt32(3);
            Status = (UpdateTargetStatus) reader.GetByte(4);
        }

        public void SaveToDatabase(SqlConnection conn, SqlTransaction transaction)
        {
            using (var command = conn.CreateCommand())
            {
                command.Transaction = transaction;
                command.Parameters.AddWithValue("@Status", (byte) Status);

                if (ID == 0)
                {
                    command.Parameters.AddWithValue("@JobID", JobID);
                    command.Parameters.AddWithValue("@ServiceHostID", ServiceHostID);
                    command.Parameters.AddWithValue("@RegionID", RegionID);
                    command.CommandText = "INSERT INTO [UpdateTarget] (JobID,ServiceHostID,RegionID,Status) OUTPUT INSERTED.ID VALUES(@JobID,@ServiceHostID,@RegionID,@Status)";
                    ID = (int) command.ExecuteScalar();
                }
                else
                {
                    command.Parameters.AddWithValue("@ID", ID);
                    command.CommandText = "UPDATE [UpdateTarget] SET Status = @Status WHERE ID = @ID";
                    command.ExecuteNonQuery();
                }
            }
        }

        public void SaveToDatabase()
        {
            using (var conn = DatabaseHelper.GetConnection())
            {
                using (var transaction = conn.BeginTransaction())
                {
                    SaveToDatabase(conn, transaction);
                    transaction.Commit();
                }
            }
        }

        public static UpdateTarget[] GetByJob(int jobID)
        {
            var targets = new List<UpdateTarget>();
            using (var conn = DatabaseHelper.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [UpdateTarget] WHERE JobID = @JobID";
                    command.Parameters.AddWithValue("@JobID", jobID);

                    using (var reader = command.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            targets.Add(new UpdateTarget(reader));
                        }
                    }
                }
            }
            return targets.ToArray();
        }
    }
}