﻿using System;
using System.Data.SqlClient;

namespace Curse.ServiceUpdate.WebService.Data
{
    public class UpdateVersion
    {
        public int ID { get; private set; }
        public int ServiceID { get; set; }
        public Version Version { get; set; }

        public UpdateVersion()
        {
        }

        private UpdateVersion(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            ServiceID = reader.GetInt32(1);
            Version = Version.Parse(reader.GetString(2));
        }

        public void SaveToDatabase()
        {
            using (var conn = DatabaseHelper.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    command.Parameters.AddWithValue("@ServiceID", ServiceID);
                    command.Parameters.AddWithValue("@Version", Version.ToString());

                    if (ID == 0)
                    {
                        command.CommandText = "INSERT INTO [UpdateVersion] (ServiceID, Version) OUTPUT INSERTED.ID VALUES(@ServiceID, @Version)";
                        ID = (int) command.ExecuteScalar();
                    }
                    else
                    {
                        command.CommandText = "UPDATE [UpdateVersion] SET ServiceID = @ServiceID, Version = @Version WHERE ID = @ID";
                        command.Parameters.AddWithValue("@ID", ID);
                        command.ExecuteNonQuery();
                    }
                }
            }
        }

        public static UpdateVersion GetByID(int id)
        {
            using (var conn = DatabaseHelper.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [UpdateVersion] WHERE ID = @ID";
                    command.Parameters.AddWithValue("@ID", id);

                    using (var reader = command.ExecuteReader())
                    {
                        return reader.Read() ? new UpdateVersion(reader) : null;
                    }
                }
            }
        }

        public static UpdateVersion GetByServiceAndVersion(int serviceID, Version version)
        {
            using (var conn = DatabaseHelper.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [UpdateVersion] WHERE ServiceID = @ServiceID AND Version = @Version";
                    command.Parameters.AddWithValue("@ServiceID", serviceID);
                    command.Parameters.AddWithValue("@Version", version.ToString());

                    using (var reader = command.ExecuteReader())
                    {
                        return reader.Read() ? new UpdateVersion(reader) : null;
                    }
                }
            }
        }
    }
}