﻿using System;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Security.Cryptography.X509Certificates;
using Curse.Logging;
using Curse.Logging.Uploader;
using Curse.ServiceUpdate.WebService.Configuration;

namespace Curse.ServiceUpdate.WebService
{
    public class Global : System.Web.HttpApplication
    {
        public static X509Certificate2 WebServiceCertificate { get; private set; }

        protected void Application_Start(object sender, EventArgs e)
        {
            Logger.Init(new LoggerConfig(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Logs"), "ServiceUpdateWebService"));
            LogUploader.Initialize(14, CoordinatorConfiguration.Instance.LogServiceUrl, CoordinatorConfiguration.Instance.ApiKey);

            Logger.Info("Initializing Service Update Web Service.");

            var store = new X509Store(StoreName.My, StoreLocation.LocalMachine);
            try
            {
                store.Open(OpenFlags.OpenExistingOnly | OpenFlags.ReadOnly);

                if (Debugger.IsAttached)
                {
                    var x = store.Certificates.Cast<X509Certificate2>().ToArray();
                    WebServiceCertificate = string.IsNullOrEmpty(CoordinatorConfiguration.Instance.CertificateThumbprint)
                        ? store.Certificates.Cast<X509Certificate2>().First(
                            c => c.FriendlyName != null && (c.FriendlyName == "*.cursevoice.dev" || c.FriendlyName == "*.cursevoice.opt" || c.FriendlyName == "*.cursevoice.stg"))
                        : store.Certificates.Find(X509FindType.FindByThumbprint, CoordinatorConfiguration.Instance.CertificateThumbprint, false)[0];
                }
                else
                {
                    WebServiceCertificate = store.Certificates.Find(X509FindType.FindByThumbprint, CoordinatorConfiguration.Instance.CertificateThumbprint, true)[0];
                }
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Error retrieving the Update Web Service's certificate.");
                throw;
            }
            finally
            {
                store.Close();
            }

            Logger.Info("Update Web Service finished initializing.");
        }

        protected void Session_Start(object sender, EventArgs e)
        {

        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {

        }

        protected void Session_End(object sender, EventArgs e)
        {

        }

        protected void Application_End(object sender, EventArgs e)
        {
            Logger.Info("Shutting down Update Web Service.");
            LogUploader.Shutdown();
        }
    }
}