﻿using System.ServiceModel;
using System.ServiceModel.Web;
using Curse.ServiceUpdate.WebService.Messages;

namespace Curse.ServiceUpdate.WebService
{
    /// <summary>
    /// Primarily exists to share the data types with the client since the manual encryption 
    /// does not expose the underlying data types.
    /// </summary>
    [ServiceContract]
    public interface IUpdateCoordinatorRest
    {
        [OperationContract]
        DeployUpdateResponse DeployUpdate(DeployUpdateRequestBody request);

        [OperationContract]
        RegisterHostResponse RegisterHost(RegisterHostBody request);

        [OperationContract]
        [WebInvoke(UriTemplate = "job/{jobID}/cancel")]
        bool CancelUpdate(string jobID, string apiKey);

        [OperationContract]
        [WebInvoke(UriTemplate = "job/{jobID}/")]
        UpdateStatusResponse Job(string jobID, string apiKey);

        [OperationContract]
        [WebGet]
        string Test();
    }
}
