﻿using System.Runtime.Serialization;
using System.ServiceModel;

namespace Curse.ServiceUpdate.WebService.Messages
{
    [DataContract]
    public enum VerifyCommitMode
    {
        [EnumMember]
        First,
        [EnumMember]
        All,
        [EnumMember]
        None
    }

    [MessageContract]
    public class DeployUpdateRequestBody
    {
        [MessageBodyMember]
        public int? RegionID { get; set; }

        [MessageBodyMember]
        public int? HostID { get; set; }

        [MessageBodyMember]
        public bool DisableRollout { get; set; }

        [MessageBodyMember]
        public string ServiceName { get; set; }

        [MessageBodyMember]
        public string ServiceVersion { get; set; }

        [MessageBodyMember]
        public VerifyCommitMode VerifyCommitMode { get; set; }

        [MessageBodyMember]
        public byte[] PayloadCertificate { get; set; }

        [MessageBodyMember]
        public byte[] PayloadSignature { get; set; }

        [MessageBodyMember]
        public byte[] Payload { get; set; }
    }
}