﻿'use strict';

import {DateUtils} from './DateUtils';

export function makeRequest<T>(url: string, headers?: any, data?: any): Promise<T> {

    return new Promise<T>((resolve, reject) => {
        let req = new XMLHttpRequest();

        req.onload = () => {
            if (req.status === 200) {
                resolve(JSON.parse(req.responseText, (k, v) => {
                    return DateUtils.tryParseDate(v);
                }));
            } else {
                reject(Error(req.statusText));
            }
        };

       
        req.onerror = error => {
            reject(error);
        };

        let method = data !== undefined ? "POST" : "GET";
        
        req.open(method, url);
        req.setRequestHeader("Content-type", "application/json; charset=utf-8");
        for (var header in headers) {
            req.setRequestHeader(header, headers[header]);
        }

        if (data !== undefined) {                        
            req.send(JSON.stringify(data));
        } else {            
            req.send();
        }
    });
}