import * as Curse_Friends_WebService_Responses from './Curse.Friends.WebService.Responses';
import * as Curse_Friends_WebService_Requests from './Curse.Friends.WebService.Requests';
import * as Curse_Friends_Data from './Curse.Friends.Data';
import * as Curse_Friends_Enums from './Curse.Friends.Enums';
import * as Curse_Aerospike from './Curse.Aerospike';
import * as Curse_Friends_Data_Search from './Curse.Friends.Data.Search';
import * as Curse_CloudSearch from './Curse.CloudSearch';
import * as Curse_Friends_NotificationContracts from './Curse.Friends.NotificationContracts';
import * as Curse_Friends_Data_DerivedModels from './Curse.Friends.Data.DerivedModels';

import {BaseWebServiceClient as base} from '../BaseWebServiceClient';
export abstract class BaseWebServiceClient extends base {

    constructor(url: string, token?: string, userID?: number) {
        super(url, token, userID);
    }

AddFriendHint(hint:Curse_Friends_WebService_Requests.FriendHintRequest):Promise<Curse_Friends_WebService_Responses.AddFriendHintResponse> {
return this.post<Curse_Friends_WebService_Responses.AddFriendHintResponse>("AddFriendHint", hint);
}

FindFriends(hint:Curse_Friends_WebService_Requests.FriendSearchRequest):Promise<Curse_Friends_WebService_Responses.FriendSearchResponse> {
return this.post<Curse_Friends_WebService_Responses.FriendSearchResponse>("FindFriends", hint);
}

GetSelfHints():Promise<Curse_Friends_WebService_Responses.GetSelfHintsResponse> {
return this.get<Curse_Friends_WebService_Responses.GetSelfHintsResponse>("GetSelfHints");
}

GetMyContacts():Promise<Curse_Friends_WebService_Responses.GetMyContactsResponse> {
return this.get<Curse_Friends_WebService_Responses.GetMyContactsResponse>("GetMyContacts");
}

GetMyFriendSuggestions():Promise<Curse_Friends_WebService_Responses.GetMyFriendSuggestionsResponse> {
return this.get<Curse_Friends_WebService_Responses.GetMyFriendSuggestionsResponse>("GetMyFriendSuggestions");
}

GetFriendsOfFriend(friendID:number):Promise<Curse_Friends_WebService_Responses.GetFriendsOfFriendResponse> {
return this.post<Curse_Friends_WebService_Responses.GetFriendsOfFriendResponse>("GetFriendsOfFriend", friendID);
}

GetMyPushNotificationPreferences():Promise<Curse_Friends_WebService_Responses.GetMyPushNotificationPreferencesResponse> {
return this.get<Curse_Friends_WebService_Responses.GetMyPushNotificationPreferencesResponse>("GetMyPushNotificationPreferences");
}

RequestFriendship(request:Curse_Friends_WebService_Requests.FriendshipRequest):Promise<Curse_Friends_WebService_Responses.RequestFriendshipResponse> {
return this.post<Curse_Friends_WebService_Responses.RequestFriendshipResponse>("RequestFriendship", request);
}

ToggleFavorite(request:Curse_Friends_WebService_Requests.ToggleFavoriteRequest):Promise<Curse_Friends_WebService_Responses.ToggleFavoriteResponse> {
return this.post<Curse_Friends_WebService_Responses.ToggleFavoriteResponse>("ToggleFavorite", request);
}

RenameFriend(request:Curse_Friends_WebService_Requests.RenameFriendRequest):Promise<Curse_Friends_WebService_Responses.RenameFriendResponse> {
return this.post<Curse_Friends_WebService_Responses.RenameFriendResponse>("RenameFriend", request);
}

ConfirmFriendship(request:Curse_Friends_WebService_Requests.ConfirmFriendshipRequest):Promise<Curse_Friends_WebService_Responses.ConfirmFriendshipResponse> {
return this.post<Curse_Friends_WebService_Responses.ConfirmFriendshipResponse>("ConfirmFriendship", request);
}

DeclineFriendship(request:Curse_Friends_WebService_Requests.DeclineFriendshipRequest):Promise<Curse_Friends_WebService_Responses.DeclineFriendshipResponse> {
return this.post<Curse_Friends_WebService_Responses.DeclineFriendshipResponse>("DeclineFriendship", request);
}

RegisterSelf(request:Curse_Friends_WebService_Requests.RegisterSelfRequest):Promise<Curse_Friends_WebService_Responses.RegisterSelfResponse> {
return this.post<Curse_Friends_WebService_Responses.RegisterSelfResponse>("RegisterSelf", request);
}

UpdateDeviceTokens(request:Curse_Friends_WebService_Requests.UpdateDeviceTokensRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("UpdateDeviceTokens", request);
}

UnregisterEndpoint(request:Curse_Friends_WebService_Requests.UnregisterEndpointRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("UnregisterEndpoint", request);
}

GetHostList():Promise<Curse_Friends_WebService_Responses.GetHostListResponse> {
return this.get<Curse_Friends_WebService_Responses.GetHostListResponse>("GetHostList");
}

ChangeStatus(request:Curse_Friends_WebService_Requests.ChangeStatusRequest):Promise<Curse_Friends_WebService_Responses.ChangeStatusResponse> {
return this.post<Curse_Friends_WebService_Responses.ChangeStatusResponse>("ChangeStatus", request);
}

ChangeGameStatus(request:Curse_Friends_WebService_Requests.ChangeGameStatusRequest):Promise<Curse_Friends_WebService_Responses.ChangeGameStatusResponse> {
return this.post<Curse_Friends_WebService_Responses.ChangeGameStatusResponse>("ChangeGameStatus", request);
}

RemoveFriendship(request:Curse_Friends_WebService_Requests.RemoveFriendshipRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("RemoveFriendship", request);
}

UnblockFriendship(request:Curse_Friends_WebService_Requests.UnblockFriendshipRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("UnblockFriendship", request);
}

ChangeFriendNotificationPreferences(request:Curse_Friends_WebService_Requests.ChangeFriendNotificationPreferencesRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("ChangeFriendNotificationPreferences", request);
}

ChangeProfile(request:Curse_Friends_WebService_Requests.ChangeProfileRequest):Promise<Curse_Friends_WebService_Responses.ChangeProfileResponse> {
return this.post<Curse_Friends_WebService_Responses.ChangeProfileResponse>("ChangeProfile", request);
}

DeclineFriendSuggestion(request:Curse_Friends_WebService_Requests.DeclineFriendSuggestionRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("DeclineFriendSuggestion", request);
}

UploadFriendHints(payload:string):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("UploadFriendHints", payload);
}

FriendListSearch(request:Curse_Friends_WebService_Requests.FriendListSearchRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("FriendListSearch", request);
}

GetUserProfile(userID:number):Promise<Curse_Friends_WebService_Responses.UserProfileResponse> {
return this.post<Curse_Friends_WebService_Responses.UserProfileResponse>("GetUserProfile", userID);
}

GetUserInfo(userID:number, apiKey:string):Promise<Curse_Friends_WebService_Responses.UserProfileResponse> {
return this.post<Curse_Friends_WebService_Responses.UserProfileResponse>("GetUserInfo", userID);
}

HealthCheck():Promise<string> {
return this.get<string>("HealthCheck");
}

ChangePushNotificationPreferences(request:Curse_Friends_WebService_Requests.ChangePushNotificationPreferencesRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("ChangePushNotificationPreferences", request);
}

CreateGroup(request:Curse_Friends_WebService_Requests.CreateGroupRequest):Promise<Curse_Friends_WebService_Responses.CreateGroupResponse> {
return this.post<Curse_Friends_WebService_Responses.CreateGroupResponse>("CreateGroup", request);
}

DeleteGroup(request:Curse_Friends_WebService_Requests.DeleteGroupRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("DeleteGroup", request);
}

RestoreChannel(request:Curse_Friends_WebService_Requests.RestoreGroupRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("RestoreChannel", request);
}

UpgradeGroup(request:Curse_Friends_WebService_Requests.UpgradeGroupRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("UpgradeGroup", request);
}

RenameGroup(request:Curse_Friends_WebService_Requests.ChangeGroupRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("RenameGroup", request);
}

ChangeGroupInfo(request:Curse_Friends_WebService_Requests.ChangeGroupRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("ChangeGroupInfo", request);
}

AddUsersToGroup(request:Curse_Friends_WebService_Requests.AddUserToGroupRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("AddUsersToGroup", request);
}

RemoveUsersFromGroup(request:Curse_Friends_WebService_Requests.RemoveUsersFromGroupRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("RemoveUsersFromGroup", request);
}

LeaveGroup(request:Curse_Friends_WebService_Requests.LeaveGroupRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("LeaveGroup", request);
}

ToggleFavoriteGroup(request:Curse_Friends_WebService_Requests.FavoriteGroupRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("ToggleFavoriteGroup", request);
}

GetGroupDetails(request:Curse_Friends_WebService_Requests.GroupDetailsRequest):Promise<Curse_Friends_WebService_Responses.GetGroupDetailsResponse> {
return this.post<Curse_Friends_WebService_Responses.GetGroupDetailsResponse>("GetGroupDetails", request);
}

AddGroupUserRole(request:Curse_Friends_WebService_Requests.ChangeGroupUserRoleRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("AddGroupUserRole", request);
}

RemoveGroupUserRole(request:Curse_Friends_WebService_Requests.ChangeGroupUserRoleRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("RemoveGroupUserRole", request);
}

ModifyGroupRole(request:Curse_Friends_WebService_Requests.ModifyGroupRoleRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("ModifyGroupRole", request);
}

CreateGroupRole(request:Curse_Friends_WebService_Requests.CreateGroupRoleRequest):Promise<Curse_Friends_WebService_Responses.CreateGroupRoleResponse> {
return this.post<Curse_Friends_WebService_Responses.CreateGroupRoleResponse>("CreateGroupRole", request);
}

ChangeGroupNotificationPreferences(request:Curse_Friends_WebService_Requests.ChangeGroupNotificationPreferencesRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("ChangeGroupNotificationPreferences", request);
}

CreateGroupInvite(request:Curse_Friends_WebService_Requests.CreateGroupInviteRequest):Promise<Curse_Friends_WebService_Responses.CreateGroupInviteResponse> {
return this.post<Curse_Friends_WebService_Responses.CreateGroupInviteResponse>("CreateGroupInvite", request);
}

ProcessGroupInvite(request:Curse_Friends_WebService_Requests.ProcessInviteRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("ProcessGroupInvite", request);
}

GetCreatedGroupInvites(request:Curse_Friends_WebService_Requests.GetCreatedGroupInvitesRequest):Promise<Curse_Friends_WebService_Responses.GetCreatedGroupInvitesResponse> {
return this.post<Curse_Friends_WebService_Responses.GetCreatedGroupInvitesResponse>("GetCreatedGroupInvites", request);
}

DeleteGroupInvite(request:Curse_Friends_WebService_Requests.DeleteGroupInviteRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("DeleteGroupInvite", request);
}

ReorganizeGroup(request:Curse_Friends_WebService_Requests.ReorganizeGroupRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("ReorganizeGroup", request);
}

AddEmoticon(request:Curse_Friends_WebService_Requests.AddEmoticonRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("AddEmoticon", request);
}

RemoveEmoticon(request:Curse_Friends_WebService_Requests.RemoveEmoticonRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("RemoveEmoticon", request);
}

CallGroup(request:Curse_Friends_WebService_Requests.CallGroupRequest):Promise<Curse_Friends_WebService_Responses.VoiceSessionResponse> {
return this.post<Curse_Friends_WebService_Responses.VoiceSessionResponse>("CallGroup", request);
}

CallFriend(request:Curse_Friends_WebService_Requests.CallFriendRequest):Promise<Curse_Friends_WebService_Responses.VoiceSessionResponse> {
return this.post<Curse_Friends_WebService_Responses.VoiceSessionResponse>("CallFriend", request);
}

UnlockCall(request:Curse_Friends_WebService_Requests.UnlockCallRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("UnlockCall", request);
}

AddFriendToCall(request:Curse_Friends_WebService_Requests.AddFriendToCallRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("AddFriendToCall", request);
}

RespondToCall(request:Curse_Friends_WebService_Requests.RespondToCallRequest):Promise<Curse_Friends_WebService_Responses.RespondToCallResponse> {
return this.post<Curse_Friends_WebService_Responses.RespondToCallResponse>("RespondToCall", request);
}

PlaceUserInGroupPromo(request:Curse_Friends_WebService_Requests.PlaceUserInPromoGroupRequest):Promise<Curse_Friends_WebService_Responses.PlaceUserInPromoGroupResponse> {
return this.post<Curse_Friends_WebService_Responses.PlaceUserInPromoGroupResponse>("PlaceUserInGroupPromo", request);
}

ProvisionGroupPromo(request:Curse_Friends_WebService_Requests.ProvisionGroupPromoRequest):Promise<Curse_Friends_WebService_Responses.ProvisionGroupPromoResponse> {
return this.post<Curse_Friends_WebService_Responses.ProvisionGroupPromoResponse>("ProvisionGroupPromo", request);
}

ProvisionGroupPromoInstances(request:Curse_Friends_WebService_Requests.ProvisionGroupPromoInstancesRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("ProvisionGroupPromoInstances", request);
}

ConversationHistory(request:Curse_Friends_WebService_Requests.ConversationHistoryRequest):Promise<Curse_Friends_WebService_Responses.ConversationHistoryResponse> {
return this.post<Curse_Friends_WebService_Responses.ConversationHistoryResponse>("ConversationHistory", request);
}

ConversationSearch(request:Curse_Friends_WebService_Requests.ConversationSearchRequest):Promise<Curse_Friends_WebService_Responses.ConversationSearchResponse> {
return this.post<Curse_Friends_WebService_Responses.ConversationSearchResponse>("ConversationSearch", request);
}

ConversationRenameAttachment(request:Curse_Friends_WebService_Requests.ConversationRenameAttachmentRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("ConversationRenameAttachment", request);
}

ConversationDeleteAttachment(request:Curse_Friends_WebService_Requests.ConversationDeleteAttachmentRequest):Promise<Curse_Friends_WebService_Responses.BasicServiceResponse> {
return this.post<Curse_Friends_WebService_Responses.BasicServiceResponse>("ConversationDeleteAttachment", request);
}



}