import * as Curse_Friends_Enums from './Curse.Friends.Enums';
import * as Curse_Friends_NotificationContracts from './Curse.Friends.NotificationContracts';
import * as Curse_SocketMessages from './Curse.SocketMessages';

import {BaseWebSocketClient as foo} from '../BaseWebSocketClient';
export abstract class BaseWebSocketClient extends foo {

    url: string;
    ws: WebSocket;
    userID: number;
    clientVersion: string;
    machineKey: string;
    actions: any;

    constructor(url: string, machineKey: string, userID: number, clientVersion: string, actions: any) {
        super(url);
        this.clientVersion = clientVersion;
        this.userID = userID;
        this.machineKey = machineKey;
        this.actions = actions;
    }

	sendChatMessageRequest(contract:Curse_Friends_NotificationContracts.ChatMessageRequest) {
		this.sendContract(770151277, contract);
	}

	sendConversationMarkReadRequest(contract:Curse_Friends_NotificationContracts.ConversationMarkReadRequest) {
		this.sendContract(-342895375, contract);
	}

	sendGroupMessageRequest(contract:Curse_Friends_NotificationContracts.GroupMessageRequest) {
		this.sendContract(1802334133, contract);
	}

	sendGroupVoiceDeclineRequest(contract:Curse_Friends_NotificationContracts.GroupVoiceDeclineRequest) {
		this.sendContract(-878956122, contract);
	}

	sendGroupVoiceInvitationRequest(contract:Curse_Friends_NotificationContracts.GroupVoiceInvitationRequest) {
		this.sendContract(-1485665202, contract);
	}

	sendUnreadConversationRequest(contract:Curse_Friends_NotificationContracts.UnreadConversationRequest) {
		this.sendContract(-136221732, contract);
	}

	sendHealthCheckRequest(contract:Curse_Friends_NotificationContracts.HealthCheckRequest) {
		this.sendContract(-1422086075, contract);
	}

	sendInstantMessageRequest(contract:Curse_Friends_NotificationContracts.InstantMessageRequest) {
		this.sendContract(-1946971478, contract);
	}

	sendVoiceDeclineRequest(contract:Curse_Friends_NotificationContracts.VoiceDeclineRequest) {
		this.sendContract(1057839404, contract);
	}

	sendVoiceInvitationRequest(contract:Curse_Friends_NotificationContracts.VoiceInvitationRequest) {
		this.sendContract(-1078244287, contract);
	}

	sendJoinRequest(contract:Curse_Friends_NotificationContracts.JoinRequest) {
		this.sendContract(-2101997347, contract);
	}

	sendHandshake(contract:Curse_SocketMessages.Handshake) {
		this.sendContract(-476754606, contract);
	}

	onAttachmentNotification(contract:Curse_Friends_NotificationContracts.AttachmentNotification) {
		 this.actions.attachmentNotification(contract);
	}

	onChatMessageResponse(contract:Curse_Friends_NotificationContracts.ChatMessageResponse) {
		 this.actions.chatMessageResponse(contract);
	}

	onChatMessageNotification(contract:Curse_Friends_NotificationContracts.ChatMessageNotification) {
		 this.actions.chatMessageNotification(contract);
	}

	onConversationReadNotification(contract:Curse_Friends_NotificationContracts.ConversationReadNotification) {
		 this.actions.conversationReadNotification(contract);
	}

	onFriendshipChangeNotification(contract:Curse_Friends_NotificationContracts.FriendshipChangeNotification) {
		 this.actions.friendshipChangeNotification(contract);
	}

	onFriendSuggestionNotification(contract:Curse_Friends_NotificationContracts.FriendSuggestionNotification) {
		 this.actions.friendSuggestionNotification(contract);
	}

	onGroupChangeNotification(contract:Curse_Friends_NotificationContracts.GroupChangeNotification) {
		 this.actions.groupChangeNotification(contract);
	}

	onGroupEmoticonNotification(contract:Curse_Friends_NotificationContracts.GroupEmoticonNotification) {
		 this.actions.groupEmoticonNotification(contract);
	}

	onGroupMembershipNotification(contract:Curse_Friends_NotificationContracts.GroupMembershipNotification) {
		 this.actions.groupMembershipNotification(contract);
	}

	onGroupNotification(contract:Curse_Friends_NotificationContracts.GroupNotification) {
		 this.actions.groupNotification(contract);
	}

	onGroupMemberNotification(contract:Curse_Friends_NotificationContracts.GroupMemberNotification) {
		 this.actions.groupMemberNotification(contract);
	}

	onGroupMessageResponse(contract:Curse_Friends_NotificationContracts.GroupMessageResponse) {
		 this.actions.groupMessageResponse(contract);
	}

	onGroupPreferenceNotification(contract:Curse_Friends_NotificationContracts.GroupPreferenceNotification) {
		 this.actions.groupPreferenceNotification(contract);
	}

	onGroupRoleNotification(contract:Curse_Friends_NotificationContracts.GroupRoleNotification) {
		 this.actions.groupRoleNotification(contract);
	}

	onGroupVoiceDeclineNotification(contract:Curse_Friends_NotificationContracts.GroupVoiceDeclineNotification) {
		 this.actions.groupVoiceDeclineNotification(contract);
	}

	onGroupVoiceInvitationNotification(contract:Curse_Friends_NotificationContracts.GroupVoiceInvitationNotification) {
		 this.actions.groupVoiceInvitationNotification(contract);
	}

	onGroupVoiceInvitationResponse(contract:Curse_Friends_NotificationContracts.GroupVoiceInvitationResponse) {
		 this.actions.groupVoiceInvitationResponse(contract);
	}

	onConversationMessageNotification(contract:Curse_Friends_NotificationContracts.ConversationMessageNotification) {
		 this.actions.conversationMessageNotification(contract);
	}

	onFriendshipRemovedNotification(contract:Curse_Friends_NotificationContracts.FriendshipRemovedNotification) {
		 this.actions.friendshipRemovedNotification(contract);
	}

	onFriendshipStatusNotification(contract:Curse_Friends_NotificationContracts.FriendshipStatusNotification) {
		 this.actions.friendshipStatusNotification(contract);
	}

	onInstantMessageResponse(contract:Curse_Friends_NotificationContracts.InstantMessageResponse) {
		 this.actions.instantMessageResponse(contract);
	}

	onUserChangeNotification(contract:Curse_Friends_NotificationContracts.UserChangeNotification) {
		 this.actions.userChangeNotification(contract);
	}

	onVoiceAcceptNotification(contract:Curse_Friends_NotificationContracts.VoiceAcceptNotification) {
		 this.actions.voiceAcceptNotification(contract);
	}

	onVoiceDeclineNotification(contract:Curse_Friends_NotificationContracts.VoiceDeclineNotification) {
		 this.actions.voiceDeclineNotification(contract);
	}

	onVoiceDeclineResponse(contract:Curse_Friends_NotificationContracts.VoiceDeclineResponse) {
		 this.actions.voiceDeclineResponse(contract);
	}

	onVoiceInvitationNotification(contract:Curse_Friends_NotificationContracts.VoiceInvitationNotification) {
		 this.actions.voiceInvitationNotification(contract);
	}

	onVoiceInvitationResponse(contract:Curse_Friends_NotificationContracts.VoiceInvitationResponse) {
		 this.actions.voiceInvitationResponse(contract);
	}

	onJoinResponse(contract:Curse_Friends_NotificationContracts.JoinResponse) {
		 this.actions.joinResponse(contract);
	}

	onUserStatusNotification(contract:Curse_Friends_NotificationContracts.UserStatusNotification) {
		 this.actions.userStatusNotification(contract);
	}

	onHandshake(contract:Curse_SocketMessages.Handshake) {
		 this.actions.handshake(contract);
	}

	registerContractMaps() {
		this.contractMap[-439561082] = (contract: any) => this.onAttachmentNotification(contract);
		this.contractTypes[-439561082] = 'AttachmentNotification';
		this.contractMap[-1633377459] = (contract: any) => this.onChatMessageResponse(contract);
		this.contractTypes[-1633377459] = 'ChatMessageResponse';
		this.contractMap[-1425256480] = (contract: any) => this.onChatMessageNotification(contract);
		this.contractTypes[-1425256480] = 'ChatMessageNotification';
		this.contractMap[-695526586] = (contract: any) => this.onConversationReadNotification(contract);
		this.contractTypes[-695526586] = 'ConversationReadNotification';
		this.contractMap[580569888] = (contract: any) => this.onFriendshipChangeNotification(contract);
		this.contractTypes[580569888] = 'FriendshipChangeNotification';
		this.contractMap[-1001397130] = (contract: any) => this.onFriendSuggestionNotification(contract);
		this.contractTypes[-1001397130] = 'FriendSuggestionNotification';
		this.contractMap[149631008] = (contract: any) => this.onGroupChangeNotification(contract);
		this.contractTypes[149631008] = 'GroupChangeNotification';
		this.contractMap[1578025038] = (contract: any) => this.onGroupEmoticonNotification(contract);
		this.contractTypes[1578025038] = 'GroupEmoticonNotification';
		this.contractMap[-358993500] = (contract: any) => this.onGroupMembershipNotification(contract);
		this.contractTypes[-358993500] = 'GroupMembershipNotification';
		this.contractMap[1283752302] = (contract: any) => this.onGroupNotification(contract);
		this.contractTypes[1283752302] = 'GroupNotification';
		this.contractMap[-815972846] = (contract: any) => this.onGroupMemberNotification(contract);
		this.contractTypes[-815972846] = 'GroupMemberNotification';
		this.contractMap[-1071406231] = (contract: any) => this.onGroupMessageResponse(contract);
		this.contractTypes[-1071406231] = 'GroupMessageResponse';
		this.contractMap[72981382] = (contract: any) => this.onGroupPreferenceNotification(contract);
		this.contractTypes[72981382] = 'GroupPreferenceNotification';
		this.contractMap[1726856442] = (contract: any) => this.onGroupRoleNotification(contract);
		this.contractTypes[1726856442] = 'GroupRoleNotification';
		this.contractMap[-1591306606] = (contract: any) => this.onGroupVoiceDeclineNotification(contract);
		this.contractTypes[-1591306606] = 'GroupVoiceDeclineNotification';
		this.contractMap[967711464] = (contract: any) => this.onGroupVoiceInvitationNotification(contract);
		this.contractTypes[967711464] = 'GroupVoiceInvitationNotification';
		this.contractMap[-747092120] = (contract: any) => this.onGroupVoiceInvitationResponse(contract);
		this.contractTypes[-747092120] = 'GroupVoiceInvitationResponse';
		this.contractMap[-635182161] = (contract: any) => this.onConversationMessageNotification(contract);
		this.contractTypes[-635182161] = 'ConversationMessageNotification';
		this.contractMap[1216900677] = (contract: any) => this.onFriendshipRemovedNotification(contract);
		this.contractTypes[1216900677] = 'FriendshipRemovedNotification';
		this.contractMap[-784944992] = (contract: any) => this.onFriendshipStatusNotification(contract);
		this.contractTypes[-784944992] = 'FriendshipStatusNotification';
		this.contractMap[1240140275] = (contract: any) => this.onInstantMessageResponse(contract);
		this.contractTypes[1240140275] = 'InstantMessageResponse';
		this.contractMap[937250613] = (contract: any) => this.onUserChangeNotification(contract);
		this.contractTypes[937250613] = 'UserChangeNotification';
		this.contractMap[1984267763] = (contract: any) => this.onVoiceAcceptNotification(contract);
		this.contractTypes[1984267763] = 'VoiceAcceptNotification';
		this.contractMap[2048237827] = (contract: any) => this.onVoiceDeclineNotification(contract);
		this.contractTypes[2048237827] = 'VoiceDeclineNotification';
		this.contractMap[1683759035] = (contract: any) => this.onVoiceDeclineResponse(contract);
		this.contractTypes[1683759035] = 'VoiceDeclineResponse';
		this.contractMap[1880393673] = (contract: any) => this.onVoiceInvitationNotification(contract);
		this.contractTypes[1880393673] = 'VoiceInvitationNotification';
		this.contractMap[-1529052412] = (contract: any) => this.onVoiceInvitationResponse(contract);
		this.contractTypes[-1529052412] = 'VoiceInvitationResponse';
		this.contractMap[-815187584] = (contract: any) => this.onJoinResponse(contract);
		this.contractTypes[-815187584] = 'JoinResponse';
		this.contractMap[707732134] = (contract: any) => this.onUserStatusNotification(contract);
		this.contractTypes[707732134] = 'UserStatusNotification';
		this.contractMap[-476754606] = (contract: any) => this.onHandshake(contract);
		this.contractTypes[-476754606] = 'Handshake';
}
}
