﻿/// IMPORTS
import { BaseWebSocketClient  } from '../BaseWebSocketClient';


export enum ServiceContractTypeTemplate {
/// CONTRACTMAPS
}

export interface ServiceEventsTemplate {
    // Connection State
    connected(id: string): void;
    connecting(): void;
    disconnected(id: string): void;

    // Service Events
/// SERVICEVENTS    
}

export abstract class WebSocketClientTemplate extends BaseWebSocketClient {

    protected events: ServiceEventsTemplate;

    constructor(url: string, events: ServiceEventsTemplate) {        
        this.events = events;
        this.events.connecting();

        super(url, {
/// CONTRACTREGISTRATION
        });
    }

    protected onSocketOpen(id: string) {
        super.onSocketOpen(id);
        this.events.connected(id);
    }

    protected onSocketClose(id: string, e: CloseEvent) {
        super.onSocketClose(id, e);
        setTimeout(() => this.events.disconnected(id));
    }

/// METHODS
}