import * as Curse_Friends_WebService_Responses from './Curse.Friends.WebService.Responses';
import * as Curse_Friends_WebService_Requests from './Curse.Friends.WebService.Requests';
import * as Curse_Friends_Enums from './Curse.Friends.Enums';
import * as Curse_Aerospike from './Curse.Aerospike';
import * as Curse_Friends_Data_Search from './Curse.Friends.Data.Search';
import * as Curse_CloudSearch from './Curse.CloudSearch';
import * as Curse_Friends_NotificationContracts from './Curse.Friends.NotificationContracts';
import * as Curse_Friends_Data_DerivedModels from './Curse.Friends.Data.DerivedModels';
export interface FriendHint {
	
	UserID:number;
	SearchTerm:string;
	Type:FriendHintType;
	GameID:number;
	Region:string;
	Server:string;
	Site:string;
	Platform:Curse_Friends_Enums.FriendPlatform;
	DisplayName:string;
	AvatarUrl:string;
	Description:string;
	Verification:FriendHintVerification;
	Status:FriendHintStatus;
	Visibility:FriendHintVisibility;
	IndexMode:Curse_Aerospike.IndexMode;
}
export enum FriendHintType {
	Unknown = 0,
	CentralID = 1,
	Username = 2,
	Email = 3,
	Site = 4,
	Game = 5,
	Platform = 6,
}
export enum FriendHintVerification {
	Unknown = 0,
	ManualEntry = 1,
	ClientSubmitted = 100,
	ClientObserved = 200,
	Verified = 300,
}
export enum FriendHintStatus {
	Normal = 0,
	Deleted = 1,
}
export enum FriendHintVisibility {
	VisibleToFriends = 0,
	VisibleToEveryone = 1,
	Hidden = 2,
}
export interface FriendSuggestion {
	
	UserID:number;
	OtherUserID:number;
	Username:string;
	AvatarUrl:string;
	FriendCount:number;
	Status:Curse_Friends_Enums.FriendSuggestionStatus;
	Type:Curse_Friends_Enums.FriendSuggestionType;
	GameID:number;
	Platform:Curse_Friends_Enums.FriendPlatform;
	RequestUsername:string;
	RequestAvatarUrl:string;
	IndexMode:Curse_Aerospike.IndexMode;
}
export interface User {
	
	UserID:number;
	Username:string;
	ConnectionStatus:Curse_Friends_Enums.UserConnectionStatus;
	CustomStatusMessage:string;
	CustomStatusTimestamp:Date;
	FriendCount:number;
	CurrentGameID:number;
	LastGameID:number;
	CurrentGameState:number;
	CurrentGameStatusMessage:string;
	CurrentGameTimestamp:Date;
	LastFriendsSuggestion:Date;
	LastStreamSync:Date;
	Name:string;
	AvatarUrl:string;
	City:string;
	State:string;
	CountryCode:string;
	AboutMe:string;
	IndexMode:Curse_Aerospike.IndexMode;
	CurrentGameClientMachineKey:string;
	GroupMessagePushPreference:Curse_Friends_Enums.PushNotificationPreference;
	FriendMessagePushPreference:Curse_Friends_Enums.PushNotificationPreference;
	FriendRequestPushEnabled:boolean;
	MentionsPushEnabled:boolean;
}
export interface GroupInvitation {
	
	InviteCode:string;
	CreatorID:number;
	GroupID:string;
	DateCreated:Date;
	DateExpires:Date;
	AutoRemoveMembers:boolean;
	Status:Curse_Friends_Enums.GroupInvitationStatus;
	IsExpired:boolean;
}

