import * as Curse_Friends_Enums from './Curse.Friends.Enums';
import * as Curse_Friends_NotificationContracts from './Curse.Friends.NotificationContracts';
import * as Curse_SocketMessages from './Curse.SocketMessages';

export enum AvatarType {
	User = 1,
	Group = 2,
}

export enum ContentTag {
	Image = 1,
	Video = 2,
	Hyperlink = 3,
	File = 4,
}

export enum ConversationEntryType {
	Message = 0,
	Notification = 1,
}

export enum ConversationType {
	Friendship = 0,
	Group = 1,
}

export enum DevicePlatform {
	Windows = 0,
	Mac = 1,
	iOS = 2,
	Android = 3,
	WindowsPhone = 4,
	Blackberry = 5,
	Chrome = 6,
	Unknown = 7,
}

export enum FriendPlatform {
	Unknown = 0,
	BattleNet = 1,
	Steam = 2,
	Facebook = 3,
	Skype = 4,
}

export enum FriendshipStatus {
	AwaitingMe = 0,
	AwaitingThem = 1,
	Confirmed = 2,
	DeclinedByMe = 3,
	DeclinedByThem = 4,
	Removing = 5,
}

export enum FriendSuggestionType {
	MutualFriend = 0,
	GameFriend = 1,
	PlatformFriend = 2,
}

export enum FriendSuggestionStatus {
	Pending = 0,
	Declined = 1,
	Accepted = 2,
}

export enum GroupChangeType {
	Unknown = 0,
	CreateGroup = 1,
	AddUsers = 2,
	RemoveUsers = 3,
	UpdateUsers = 4,
	ChangeInfo = 5,
	VoiceSessionStarted = 6,
	VoiceSessionEnded = 7,
	VoiceSessionUserJoined = 8,
	VoiceSessionUserLeft = 9,
	RemoveGroup = 10,
	GroupReorganized = 11,
	PermissionsChanged = 12,
	RoleNamesChanged = 13,
	UpdateEmoticons = 14,
}

export enum GroupEventType {
	RootGroupCreated = 0,
	SubgroupCreated = 1,
	SubgroupRemoved = 2,
	UserInvited = 3,
	UsersAdded = 4,
	UsersRemoved = 5,
	UserLeft = 6,
	UserPromoted = 7,
	UserDemoted = 8,
	GroupTitleChanged = 9,
	GroupAvatarChanged = 10,
}

export enum GroupInvitationStatus {
	Active = 0,
	Invalid = 1,
	Defunct = 2,
}

export enum GroupMembershipStatus {
	Subscribed = 0,
	Unsubscribed = 1,
}

export enum GroupPermissions {
	None = 0,
	Access = 1,
	ManageServer = 2,
	ManageChannels = 4,
	CreateTemporaryGroup = 8,
	AccessAdminPanel = 16,
	InviteUsers = 32,
	RemoveUser = 64,
	ManageInvitations = 128,
	ChangeUserRole = 256,
	BanUser = 512,
	VoiceKickUser = 1024,
	VoiceMuteUser = 2048,
	VoiceDeafenUser = 4096,
	VoiceSpeak = 8192,
	VoiceMoveUser = 16384,
	VoiceChangeSettings = 32768,
	ChatSendMessages = 65536,
	ChatEmbedLinks = 131072,
	ChatUploadPhotos = 262144,
	ChatAttachFiles = 524288,
	ChatReadHistory = 1048576,
	ChatMentionUsers = 2097152,
	ChatMentionEveryone = 4194304,
	ChatModerateMessages = 8388608,
	SendPrivateMessage = 16777216,
	All = -1,
}

export enum GroupPermissionState {
	Allowed = 0,
	AllowedInherited = 1,
	NotAllowed = 2,
	NotAllowedInherited = 3,
}

export enum LegacyGroupRole {
	None = 0,
	Guest = 100,
	Member = 200,
	Officer = 300,
	Admin = 400,
	Owner = 1000,
}

export enum GroupStatus {
	Normal = 0,
	Deleted = 1,
}

export enum GroupType {
	Normal = 0,
	Large = 1,
	Temporary = 2,
}

export enum HostEnvironment {
	Unknown = 0,
	Debug = 1,
	Staging = 2,
	Beta = 3,
	Release = 4,
}

export enum NotificationPreference {
	Enabled = 0,
	Disabled = 1,
	Filtered = 2,
}

export enum PushNotificationPreference {
	All = 0,
	Favorites = 1,
	None = 2,
}

export enum PushNotificationType {
	Unknown = 0,
	InstantMessage = 1,
	GroupMessage = 2,
	FriendRequest = 3,
	FriendConfirmation = 4,
	IncomingCall = 5,
}

export enum UserConnectionStatus {
	Offline = 0,
	Online = 1,
	Away = 2,
	Invisible = 3,
	Idle = 4,
	DoNotDisturb = 5,
}


