import * as Curse_Friends_WebService_Responses from './Curse.Friends.WebService.Responses';
import * as Curse_Friends_WebService_Requests from './Curse.Friends.WebService.Requests';
import * as Curse_Friends_Enums from './Curse.Friends.Enums';
import * as Curse_Friends_Data_Search from './Curse.Friends.Data.Search';
import * as Curse_CloudSearch from './Curse.CloudSearch';
import * as Curse_Friends_Data from './Curse.Friends.Data';
import * as Curse_Aerospike from './Curse.Aerospike';
import * as Curse_Friends_Data_DerivedModels from './Curse.Friends.Data.DerivedModels';
export interface FriendHintNotification {
	

	ID:number;
	UserID:number;
	SearchTerm:string;
	Type:Curse_Friends_Enums.FriendHintType;
	GameID:number;
	Region:string;
	Server:string;
	Site:string;
	Platform:Curse_Friends_Enums.FriendPlatform;
	DisplayName:string;
	AvatarUrl:string;
	Description:string;
	Verification:Curse_Friends_Enums.FriendHintVerification;
	Status:Curse_Friends_Enums.FriendHintStatus;
	Visibility:Curse_Friends_Enums.FriendHintVisibility;
}
export interface FriendshipContract {
	

	Status:Curse_Friends_Enums.FriendshipStatus;
	OtherUserID:number;
	OtherUsername:string;
	OtherUserNickname:string;
	OtherUserRegionID:number;
	OtherUserConnectionStatus:Curse_Friends_Enums.UserConnectionStatus;
	InvitationMessage:string;
	IsFavorite:boolean;
	OtherUserStatusMessage:string;
	OtherUserGameID:number;
	OtherUserGameStatusMessage:string;
	OtherUserGameState:number;
	OtherUserGameTimestamp:string;
	OtherUserAvatarUrl:string;
	DateConfirmed:string;
	DateMessaged:string;
	DateRead:string;
	UnreadCount:number;
	MutualFriendCount:number;
}
export interface GroupNotification {
	

	GroupTitle:string;
	GroupID:string;
	ParentGroupID:string;
	RootGroupID:string;
	VoiceSessionCode:string;
	MessageOfTheDay:string;
	GroupType:Curse_Friends_Enums.GroupType;
	GroupSubtype:Curse_Friends_Enums.GroupSubType;
	DisplayOrder:number;
	MetaDataOnly:boolean;
	AllowTemporaryChildGroups:boolean;
	ForcePushToTalk:boolean;
	Status:Curse_Friends_Enums.GroupStatus;
	IsDefaultChannel:boolean;
	Roles:GroupRoleNotification[];
	RolePermissions:any[];
	Membership:GroupMembershipNotification;
	MemberCount:number;
	Emotes:GroupEmoticonNotification[];
	Members:GroupMemberContract[];
	Channels:ChannelContract[];
	GroupMode:Curse_Friends_Enums.GroupMode;
	UrlPath:string;
	UrlHost:string;
}
export interface GroupRoleNotification {
	

	RoleID:number;
	Name:string;
	Rank:number;
	VanityColor:number;
	VanityBadge:number;
	HasCustomVanityBadge:boolean;
	IsDefault:boolean;
	IsOwner:boolean;
}
export interface GroupMembershipNotification {
	

	BestRole:number;
	Roles:number[];
	DateJoined:string;
	DateMessaged:string;
	DateRead:string;
	UnreadCount:number;
	IsFavorite:boolean;
	NotificationPreference:Curse_Friends_Enums.NotificationPreference;
	NotificationFilters:string[];
	NotificationMuteDate:string;
}
export interface GroupEmoticonNotification {
	

	GroupID:string;
	RegexString:string;
	SyncID:string;
	Url:string;
	RequiredRoles:number[];
}
export interface GroupMemberContract {
	

	UserID:number;
	Username:string;
	RegionID:number;
	BestRole:number;
	Roles:number[];
}
export interface ChannelContract {
	

	GroupTitle:string;
	GroupID:string;
	ParentGroupID:string;
	RootGroupID:string;
	VoiceSessionCode:string;
	MessageOfTheDay:string;
	GroupMode:Curse_Friends_Enums.GroupMode;
	GroupType:Curse_Friends_Enums.GroupType;
	GroupStatus:Curse_Friends_Enums.GroupStatus;
	DisplayOrder:number;
	AllowTemporaryChildGroups:boolean;
	ForcePushToTalk:boolean;
	IsDefaultChannel:boolean;
	RolePermissions:any[];
	UnreadCount:number;
}
export interface FriendSuggestionContract {
	

	FriendID:number;
	Username:string;
	AvatarUrl:string;
	FriendCount:number;
	Type:Curse_Friends_Enums.FriendSuggestionType;
	GameID:number;
	Platform:Curse_Friends_Enums.FriendPlatform;
}
export interface GroupMemberNotification {
	

	UserID:number;
	Username:string;
	RegionID:number;
	Role:Curse_Friends_Enums.LegacyGroupRole;
	CurrentGroupID:string;
}

