import * as Curse_Friends_WebService_Responses from './Curse.Friends.WebService.Responses';
import * as Curse_Friends_NotificationContracts from './Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './Curse.Friends.Enums';
import * as Curse_Friends_Data_Search from './Curse.Friends.Data.Search';
import * as Curse_CloudSearch from './Curse.CloudSearch';
import * as Curse_Friends_Data from './Curse.Friends.Data';
import * as Curse_Aerospike from './Curse.Aerospike';
import * as Curse_Friends_Data_DerivedModels from './Curse.Friends.Data.DerivedModels';
export interface FriendHintRequest {
	

	Identity:Curse_Friends_NotificationContracts.FriendHintNotification;
}
export interface FriendSearchRequest {
	

	QueryString:string;
}
export interface FriendshipRequest {
	

	FriendID:number;
	KnownIdentity:string;
	InvitationMessage:string;
	IsFromSuggestion:boolean;
}
export interface ToggleFavoriteRequest {
	

	FriendID:number;
	IsFavorite:boolean;
}
export interface RenameFriendRequest {
	

	FriendID:number;
	Nickname:string;
}
export interface ConfirmFriendshipRequest {
	

	FriendID:number;
}
export interface DeclineFriendshipRequest {
	

	FriendID:number;
	BlockFutureRequests:boolean;
}
export interface RegisterSelfRequest {
	

	MachineKey:string;
	Status:Curse_Friends_Enums.UserConnectionStatus;
	Platform:Curse_Friends_Enums.DevicePlatform;
	DeviceID:string;
	PushKitToken:string;
}
export interface UpdateDeviceTokensRequest {
	

	MachineKey:string;
	DeviceID:string;
	PushKitID:string;
}
export interface UnregisterEndpointRequest {
	

	MachineKey:string;
	DeviceID:string;
}
export interface ChangeStatusRequest {
	

	MachineKey:string;
	Status:Curse_Friends_Enums.UserConnectionStatus;
	CustomStatusMessage:string;
}
export interface ChangeGameStatusRequest {
	

	GameID:number;
	GameState:number;
	GameStatusMessage:string;
	IsRunning:boolean;
	MachineKey:string;
}
export interface RemoveFriendshipRequest {
	

	FriendID:number;
}
export interface UnblockFriendshipRequest {
	

	FriendID:number;
}
export interface ChangeFriendNotificationPreferencesRequest {
	

	FriendID:number;
	Preference:Curse_Friends_Enums.NotificationPreference;
	FilterSet:string[];
}
export interface ChangeProfileRequest {
	

	AvatarUrl:string;
	Name:string;
	City:string;
	State:string;
	CountryCode:string;
	AboutMe:string;
}
export interface DeclineFriendSuggestionRequest {
	

	FriendID:number;
}
export interface FriendListSearchRequest {
	

	Identity:Curse_Friends_Data.FriendHint;
	FriendsList:Curse_Friends_Data.FriendHint[];
}
export interface ChangePushNotificationPreferencesRequest {
	

	GroupMessagePushPreference:Curse_Friends_Enums.PushNotificationPreference;
	FriendMessagePushPreference:Curse_Friends_Enums.PushNotificationPreference;
	FriendRequestPushEnabled:boolean;
	MentionsPushEnabled:boolean;
}
export interface CreateGroupRequest {
	

	RecipientsUserIDs:number[];
	Title:string;
}
export interface ChangeGroupRequest {
	

	GroupID:string;
	Title:string;
	AvatarUrl:string;
	MessageOfTheDay:string;
	AllowTemporaryChildGroups:boolean;
	ForcePushToTalk:boolean;
}
export interface AddUserToGroupRequest {
	

	GroupID:string;
	UserIDs:number[];
}
export interface RemoveUsersFromGroupRequest {
	

	GroupID:string;
	UserIDs:number[];
}
export interface LeaveGroupRequest {
	

	GroupID:string;
}
export interface FavoriteGroupRequest {
	

	GroupID:string;
	IsFavorite:boolean;
}
export interface GroupDetailsRequest {
	

	GroupID:string;
	ShowDeletedChannels:boolean;
	IncludeRoleNames:boolean;
	IncludePermissions:boolean;
}
export interface ChangeGroupNotificationPreferencesRequest {
	

	GroupID:string;
	Preference:Curse_Friends_Enums.NotificationPreference;
	FilterSet:string[];
}
export interface CallGroupRequest {
	

	GroupID:string;
	ClientVersion:string;
	Force:boolean;
	SendInvitation:boolean;
	TargetUserIDs:any;
}
export interface CallFriendRequest {
	

	FriendID:number;
	ClientVersion:string;
	Force:boolean;
	SendInvitation:boolean;
}
export interface UnlockCallRequest {
	

	CallCode:string;
	FriendToAdd:number;
}
export interface AddFriendToCallRequest {
	

	CallCode:string;
	FriendID:number;
}
export interface RespondToCallRequest {
	

	InviteUrl:string;
	GroupID:string;
	FriendID:number;
	Accepted:boolean;
}

