import * as Curse_Friends_WebService_Requests from './Curse.Friends.WebService.Requests';
import * as Curse_Friends_NotificationContracts from './Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './Curse.Friends.Enums';
import * as Curse_Friends_Data_Search from './Curse.Friends.Data.Search';
import * as Curse_CloudSearch from './Curse.CloudSearch';
import * as Curse_Friends_Data from './Curse.Friends.Data';
import * as Curse_Aerospike from './Curse.Aerospike';
import * as Curse_Friends_Data_DerivedModels from './Curse.Friends.Data.DerivedModels';
export interface AddFriendHintResponse {
	

	Status:AddFriendHintResponseStatus;
}
export enum AddFriendHintResponseStatus {
	Unknown = 0,
	Successful = 1,
	Unauthorized = 2,
	Error = 3,
	Invalid = 4,
}
export interface FriendSearchResponse {
	

	CharacterMatches:Curse_CloudSearch.CloudSearchResultOfCharacterSearchModel[];
	EmailMatches:Curse_CloudSearch.CloudSearchResultOfEmailSearchModel[];
	UserMatches:Curse_CloudSearch.CloudSearchResultOfUsernameSearchModel[];
	PlatformMatches:Curse_CloudSearch.CloudSearchResultOfPlatformSearchModel[];
	ElapsedMilliseconds:number;
	Status:FriendSearchStatus;
}
export enum FriendSearchStatus {
	Unknown = 0,
	Successful = 1,
	Error = 2,
	Invalid = 3,
}
export interface GetSelfHintsResponse {
	

	Hints:Curse_Friends_Data.FriendHint[];
	Status:GetSelfHintsResponseStatus;
}
export enum GetSelfHintsResponseStatus {
	Unknown = 0,
	Successful = 1,
	Unauthorized = 2,
	Error = 3,
}
export interface GetMyContactsResponse {
	

	Status:BasicServiceResponseStatus;
	Friends:Curse_Friends_NotificationContracts.FriendshipContract[];
	Groups:Curse_Friends_NotificationContracts.GroupNotification[];
}
export enum BasicServiceResponseStatus {
	Unknown = 0,
	Error = 1,
	Invalid = 2,
	NotFound = 3,
	Successful = 4,
	Forbidden = 5,
}
export interface GetMyFriendsResponse {
	

	Friends:Curse_Friends_Data.Friendship[];
	Status:GetMyFriendsStatus;
}
export enum GetMyFriendsStatus {
	Unknown = 0,
	Successful = 1,
	Unauthorized = 2,
	Error = 3,
	Invalid = 4,
}
export interface GetMyFriendSuggestionsResponse {
	

	Status:GetMyFriendSuggestionsStatus;
	Suggestions:Curse_Friends_NotificationContracts.FriendSuggestionContract[];
}
export enum GetMyFriendSuggestionsStatus {
	Unknown = 0,
	Successful = 1,
	Unauthorized = 2,
	Error = 3,
}
export interface GetFriendsOfFriendResponse {
	

	Status:BasicServiceResponseStatus;
	FriendsOfFriend:FriendOfFriendDetails[];
}
export interface FriendOfFriendDetails {
	

	UserID:number;
	Username:string;
}
export interface GetMyPushNotificationPreferencesResponse {
	

	Status:GetMyPushNotificationPreferencesStatus;
	FriendMessagePushPreference:Curse_Friends_Enums.PushNotificationPreference;
	GroupMessagePushPreference:Curse_Friends_Enums.PushNotificationPreference;
	FriendRequestPushEnabled:boolean;
	MentionsPushEnabled:boolean;
}
export enum GetMyPushNotificationPreferencesStatus {
	Unknown = 0,
	Success = 1,
	Unauthorized = 2,
	Error = 3,
}
export interface RequestFriendshipResponse {
	

	Status:RequestFriendshipStatus;
}
export enum RequestFriendshipStatus {
	Unknown = 0,
	Error = 1,
	NotFound = 2,
	AlreadyRequested = 3,
	FailedValidation = 4,
	MaximumFriends = 5,
	Successful = 6,
}
export interface ToggleFavoriteResponse {
	

	Status:ToggleFavoriteStatus;
}
export enum ToggleFavoriteStatus {
	Unknown = 0,
	Error = 1,
	NotFound = 2,
	Successful = 3,
}
export interface RenameFriendResponse {
	

	Status:RenameFriendStatus;
}
export enum RenameFriendStatus {
	Unknown = 0,
	Error = 1,
	NotFound = 2,
	Successful = 3,
}
export interface ConfirmFriendshipResponse {
	

	Status:ConfirmFriendshipStatus;
}
export enum ConfirmFriendshipStatus {
	Unknown = 0,
	Successful = 1,
	Error = 2,
	NotFound = 3,
}
export interface DeclineFriendshipResponse {
	

	Status:DeclineFriendshipStatus;
}
export enum DeclineFriendshipStatus {
	Unknown = 0,
	Successful = 1,
	Error = 2,
	NotFound = 3,
	FailedValidation = 4,
}
export interface RegisterSelfResponse {
	

	Status:RegisterSelfStatus;
	SessionID:string;
	NotificationHostPort:number;
	NotificationHostPorts:any;
	NotificationHostList:any;
	User:Curse_Friends_Data.User;
}
export enum RegisterSelfStatus {
	Unknown = 0,
	Successful = 1,
	Error = 2,
}
export interface BasicServiceResponse {
	

	Status:BasicServiceResponseStatus;
	StatusMessage:string;
}
export interface GetHostListResponse {
	

	NotificationHostPort:number;
	NotificationHostPorts:any;
	NotificationHostList:any;
}
export interface ChangeStatusResponse {
	

	Status:ChangeStatusStatus;
	ValidationMessage:string;
}
export enum ChangeStatusStatus {
	Unknown = 0,
	Error = 1,
	NotRegistered = 2,
	Successful = 3,
	Invalid = 4,
}
export interface ChangeGameStatusResponse {
	

	Status:ChangeGameStatusStatus;
}
export enum ChangeGameStatusStatus {
	Unknown = 0,
	Error = 1,
	NotRegistered = 2,
	Successful = 3,
	Invalid = 4,
}
export interface ChangeProfileResponse {
	

	Status:ChangeProfileStatus;
}
export enum ChangeProfileStatus {
	Unknown = 0,
	Error = 1,
	NotRegistered = 2,
	Successful = 3,
	Invalid = 4,
}
export interface UserProfileResponse {
	

	Status:BasicServiceResponseStatus;
	UserID:number;
	Username:string;
	AvatarUrl:string;
	Name:string;
	City:string;
	State:string;
	CountryCode:string;
	AboutMe:string;
	Identities:Curse_Friends_Data.FriendHint[];
	MutualFriends:Curse_Friends_Data_DerivedModels.MutualFriend[];
	FriendCount:number;
	LastGameID:number;
}
export interface CreateGroupResponse {
	

	Status:CreateGroupStatus;
	ErrorMessage:string;
	GroupID:string;
}
export enum CreateGroupStatus {
	UnknownError = 0,
	Successful = 1,
	Error = 2,
	Throttled = 3,
	RenameError = 4,
	Forbidden = 5,
	InvalidRecipients = 6,
}
export interface GetMyGroupsResponse {
	

	Groups:Curse_Friends_Data.GroupMembership[];
	Status:BasicServiceResponseStatus;
}
export interface GetGroupDetailsResponse {
	

	Status:BasicServiceResponseStatus;
	Members:Curse_Friends_NotificationContracts.GroupMemberNotification[];
	Groups:Curse_Friends_NotificationContracts.GroupNotification[];
	GroupMembership:Curse_Friends_Data.GroupMembership;
	Permissions:any[];
}
export interface VoiceSessionResponse {
	

	Status:VoiceSessionRequestStatus;
	AccessToken:number;
	InviteUrl:string;
}
export enum VoiceSessionRequestStatus {
	Successful = 1,
	Invalid = 2,
	Forbidden = 3,
	Error = 4,
	IncompatibleClient = 5,
	Throttled = 6,
	NoHostsAvailable = 7,
}
export interface RespondToCallResponse {
	

	Status:RespondToCallStatus;
	Timestamp:string;
}
export enum RespondToCallStatus {
	Error = 0,
	NotFound = 1,
	Invalid = 2,
	Forbidden = 3,
	Successful = 4,
}

