﻿using System;
using System.Linq;
using Curse.ServiceClients.Contracts;

namespace Curse.ServiceClients.Examples
{

    public class Program
    {
        private static string GetPassword()
        {
            var pwd = string.Empty;
            while (true)
            {
                var i = Console.ReadKey(true);
                if (i.Key == ConsoleKey.Enter)
                {
                    break;
                }
                else if (i.Key == ConsoleKey.Backspace)
                {
                    if (pwd.Length > 0)
                    {
                        pwd = pwd.Substring(pwd.Length - 1);
                        Console.Write("\b \b");
                    }
                }
                else
                {
                    pwd = pwd + (i.KeyChar);
                    Console.Write("*");
                }
            }
            return pwd;
        }

        public static void Main()
        {
            // Set the default service URLs (This is a convenience method, so that URLs don't have to be set manually)
            ServicesConfiguration.SetDefaultUrls();

            if (!Login())
            {
                return;
            }

            // Get the current user's friends list
            var c = Services.Instance.Contacts.GetAll();
            if (!c.Success)
            {
                Console.WriteLine("Failed to get contacts: " + c.StatusCode);
                return;
            }

            Console.WriteLine("Retrieved {0} friends and {1} groups.", c.Response.Friends.Length, c.Response.Groups.Length);
            Console.WriteLine("{0} unread friend conversations and {1} unread group conversations.", c.Response.Friends.Count(p => p.UnreadCount > 0), c.Response.Groups.Count(p => p.Membership.UnreadCount > 0 || (p.Channels != null && p.Channels.Any(channel => channel.Membership.UnreadCount > 0))));
            Console.WriteLine();

            // Get the current user's profile
            var u = Services.Instance.Account.GetProfile();

            if (!c.Success)
            {
                Console.WriteLine("Failed to get user profie: " + u.StatusCode);
                return;
            }
                                    

            Console.WriteLine("Retrieved user's profile: {0}. ", u.Response.Username);
            Console.WriteLine();

            Console.WriteLine("Press enter to continue...");
            Console.ReadLine();

        }

        static bool Login()
        {
            // Login to the app to get a token
            Console.WriteLine("Enter your username: ");
            var username = Console.ReadLine();

            Console.WriteLine("Enter your password: ");
            var password = GetPassword();

            Console.WriteLine();
            Console.Write("Logging in...");

            // Login
            var resp = Services.Instance.Login.Login(new LoginRequest { Username = username, Password = password });


            if (!resp.Success)
            {
                Console.WriteLine("Failed");
                Console.WriteLine("Response status: " + resp.StatusCode);
                Console.ReadKey(true);
                return false;
            }

            Console.WriteLine("Success");

            // Set the token. Now we can authenticate to any service. Note: You can also cache this token, and use it until expiration. 
            // The response includes a renewal timestamp.
            ServiceAuthentication.Token = resp.Response.Session.Token;
            return true;
        }

       
    }
}
