using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class AvatarAdminService : BaseWebServiceClient
    {
        public AvatarAdminService(string url) : base(url)
        {
            
        }

		public ServiceResponse<FindUserAvatarSearchResult[]> FindUserAvatar(FindUserAvatarSearchRequest search) {
			return Post<FindUserAvatarSearchResult[]>("avatars/api/quarantine/users/search", search);
		}

		public ServiceResponse MarkAvatarAsInappropriate(MarkAvatarInappropriateRequest request) {
			return Post("avatars/api/quarantine/users", request);
		}

		public ServiceResponse UnmarkAvatarAsInappropriate(int userID) {
			return Delete(string.Format("avatars/api/quarantine/users/{0}", userID));
		}

		public ServiceResponse<GetAvatarResult[]> GetAvatar(string entityID) {
			return Get<GetAvatarResult[]>(string.Format("avatars/api/{0}", entityID));
		}

		public ServiceResponse PurgeAvatar(AvatarType type, string entityID) {
			return Delete(string.Format("avatars/api/{0}/{1}", type, entityID));
		}

		public ServiceResponse<ImageMetadata> ChangeAvatarBase64(AvatarType type, string entityID, string value) {
			return Post<ImageMetadata>(string.Format("avatars/api/{0}/{1}/base64", type, entityID), value);
		}

		public ServiceResponse ChangeAvatarUrl(AvatarType type, string entityID, string url) {
			return Post(string.Format("avatars/api/{0}/{1}/url", type, entityID), url);
		}


    }
}
