using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class CallsService : BaseWebServiceClient
    {
        public CallsService(string url) : base(url)
        {
            
        }

		public ServiceResponse<CallNotification> Conversation(string conversationID, ConversationCallRequest request) {
			return Post<CallNotification>(string.Format("calls/conversations/{0}", conversationID), request);
		}

		public ServiceResponse<CallNotification> AdHoc(AdHocCallRequest request) {
			return Post<CallNotification>("calls/adhoc", request);
		}

		public ServiceResponse DeclineAutoMatch(long autoMatchKey) {
			return Delete(string.Format("calls/automatch/handshake/{0}", autoMatchKey));
		}

		public ServiceResponse<HandshakeAutoMatchResponse> AutoMatchHandshake(long autoMatchKey, HandshakeAutoMatchRequest request) {
			return Post<HandshakeAutoMatchResponse>(string.Format("calls/automatch/handshake/{0}", autoMatchKey), request);
		}

		public ServiceResponse<CallNotification> AutoMatch(AutoMatchCallRequest request) {
			return Post<CallNotification>("calls/automatch", request);
		}

		public ServiceResponse<CallNotification> AdHocDetails(string inviteCode) {
			return Get<CallNotification>(string.Format("calls/adhoc/{0}", inviteCode));
		}

		public ServiceResponse<AdHocCallDisplayDetailsResponse> AdHocDisplayDetails(string inviteCode) {
			return Get<AdHocCallDisplayDetailsResponse>(string.Format("calls/adhoc/{0}/display", inviteCode));
		}

		public ServiceResponse AddFriendToCall(string callID, int friendID) {
			return Post(string.Format("calls/{0}/invite", callID), friendID);
		}

		public ServiceResponse Decline(string callID) {
			return Post(string.Format("calls/{0}/decline", callID));
		}

		public ServiceResponse Accept(string callID) {
			return Post(string.Format("calls/{0}/accept", callID));
		}

		public ServiceResponse Unlock(string callID) {
			return Post(string.Format("calls/{0}/unlock", callID));
		}

		public ServiceResponse EnableVideo(string callID) {
			return Post(string.Format("calls/{0}/enable-video", callID));
		}

		public ServiceResponse MuteUser(string conversationID, int userID) {
			return Post(string.Format("calls/{0}/moderation/muted-users", conversationID), userID);
		}

		public ServiceResponse UnmuteUser(string conversationID, int userID) {
			return Delete(string.Format("calls/{0}/moderation/muted-users/{1}", conversationID, userID));
		}

		public ServiceResponse DeafenUser(string conversationID, DeafenUserRequest request) {
			return Post(string.Format("calls/{0}/moderation/deafened-users", conversationID), request);
		}

		public ServiceResponse UndeafenUser(string conversationID, int userID, bool unmute) {
			return Delete(string.Format("calls/{0}/moderation/deafened-users/{1}?unmute={1}", conversationID, userID));
		}

		public ServiceResponse KickUser(string conversationID, int userID) {
			return Delete(string.Format("calls/{0}/moderation/{1}", conversationID, userID));
		}

		public ServiceResponse MoveUser(Guid groupID, int userID, MoveUserRequest request) {
			return Post(string.Format("calls/{0}/moderation/{1}/move", groupID, userID), request);
		}

		public ServiceResponse ReportGameSessions(ReportGameSessionsRequest request) {
			return Post("calls/games/metrics", request);
		}

		public ServiceResponse SetSessionGameState(string sessionGuid, int gameID) {
			return Post(string.Format("calls/sessions/{0}/games/{1}", sessionGuid, gameID));
		}


    }
}
