using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class ConversationsService : BaseWebServiceClient
    {
        public ConversationsService(string url) : base(url)
        {
            
        }

		public ServiceResponse<ConversationMessageNotification[]> History(string id, long endTimestamp, int pageSize, long startTimestamp) {
			return Get<ConversationMessageNotification[]>(string.Format("conversations/{0}", id) + string.Format("?endTimestamp={0}&pageSize={1}&startTimestamp={2}",endTimestamp,pageSize,startTimestamp));
		}

		public ServiceResponse<ConversationMessageNotification[]> Jump(string id, long timestamp, int pageSizeBefore, int pageSizeAfter) {
			return Get<ConversationMessageNotification[]>(string.Format("conversations/{0}/jump", id) + string.Format("?timestamp={0}&pageSizeBefore={1}&pageSizeAfter={2}",timestamp,pageSizeBefore,pageSizeAfter));
		}

		public ServiceResponse EditAttachment(string conversationID, string attachmentID, ConversationAttachmentEditRequest request) {
			return Post(string.Format("conversations/{0}/attachments/{1}", conversationID, attachmentID), request);
		}

		public ServiceResponse DeleteAttachment(string conversationID, string attachmentID, ConversationDeleteAttachmentRequest request) {
			return Delete(string.Format("conversations/{0}/attachments/{1}", conversationID, attachmentID) + string.Format("?request={0}",request));
		}

		public ServiceResponse<ConversationSearchItem[]> Search(string conversationID, ConversationSearchRequest searchFilters) {
			return Post<ConversationSearchItem[]>(string.Format("conversations/{0}/search", conversationID), searchFilters);
		}

		public ServiceResponse Hide(string conversationID) {
			return Post(string.Format("conversations/{0}/hide", conversationID));
		}

		public ServiceResponse Unhide(string conversationID) {
			return Post(string.Format("conversations/{0}/unhide", conversationID));
		}

		public ServiceResponse Mute(string conversationID) {
			return Post(string.Format("conversations/{0}/mute", conversationID));
		}

		public ServiceResponse Unmute(string conversationID) {
			return Post(string.Format("conversations/{0}/unmute", conversationID));
		}

		public ServiceResponse CreateMessage(string conversationID, ConversationCreateMessageRequest request) {
			return Post(string.Format("conversations/{0}", conversationID), request);
		}

		public ServiceResponse SendTwitchWhisper(string twitchID, ConversationCreateMessageRequest request) {
			return Post(string.Format("conversations/twitch/{0}", twitchID), request);
		}

		public ServiceResponse EditMessage(string conversationID, string id, long timestamp, ConversationEditMessageRequest request) {
			return Post(string.Format("conversations/{0}/{1}-{2}", conversationID, id, timestamp), request);
		}

		public ServiceResponse DeleteMessage(string conversationID, string id, long timestamp) {
			return Delete(string.Format("conversations/{0}/{1}-{2}", conversationID, id, timestamp));
		}

		public ServiceResponse LikeMessage(string conversationID, string id, long timestamp) {
			return Post(string.Format("conversations/{0}/{1}-{2}/like", conversationID, id, timestamp));
		}

		public ServiceResponse UnlikeMessage(string conversationID, string id, long timestamp) {
			return Post(string.Format("conversations/{0}/{1}-{2}/unlike", conversationID, id, timestamp));
		}

		public ServiceResponse MarkAsRead(string conversationID, ConversationMarkReadRequest request) {
			return Post(string.Format("conversations/{0}/mark-as-read", conversationID), request);
		}

		public ServiceResponse MarkAllAsRead() {
			return Post("conversations/mark-all-as-read");
		}

		public ServiceResponse FlagAsSpam(string conversationID, ConversationFlagSpamRequest request) {
			return Post(string.Format("conversations/{0}/flag-as-spam", conversationID), request);
		}


    }
}
