using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class GroupsApiService : BaseWebServiceClient
    {
        public GroupsApiService(string url) : base(url)
        {
            
        }

		public ServiceResponse SetServerFeatured(Guid serverID, bool isFeatured) {
			return Post(string.Format("groups/api/{0}/featured", serverID), isFeatured);
		}

		public ServiceResponse AddOwner(Guid groupID, int userID) {
			return Post(string.Format("groups/api/{0}/members/owners", groupID), userID);
		}

		public ServiceResponse BlacklistVanityUrls(string[] urlsToBlacklist) {
			return Post("groups/api/vanity-urls/blacklists", urlsToBlacklist);
		}

		public ServiceResponse ReserveVanityUrls(string[] urlsToReserve) {
			return Post("groups/api/vanity-urls/reserves", urlsToReserve);
		}

		public ServiceResponse AssignVanityUrl(Guid groupID, string url) {
			return Post(string.Format("groups/api/vanity-urls/groups/{0}", groupID), url);
		}

		public ServiceResponse<ApiGroupSearchContract[]> SearchGroups(SearchServersRequest request) {
			return Post<ApiGroupSearchContract[]>("groups/api/discover/search", request);
		}

		public ServiceResponse MarkInappropriate(MarkInappropriateRequest request) {
			return Post("groups/api/discover/quarantine", request);
		}

		public ServiceResponse UnmarkInappropriate(Guid serverID) {
			return Post(string.Format("groups/api/discover/quarantine/{0}", serverID));
		}


    }
}
