using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class LinkedAccountsService : BaseWebServiceClient
    {
        public LinkedAccountsService(string url) : base(url)
        {
            
        }

		public ServiceResponse<ExternalAccountContract[]> GetMyAccounts() {
			return Get<ExternalAccountContract[]>("linked-accounts");
		}

		public ServiceResponse<TemporaryAccessTokenContract> CreateTemporaryAccessToken() {
			return Post<TemporaryAccessTokenContract>("linked-accounts/token");
		}

		public ServiceResponse<string> LinkAccountWithToken(AccountType type, int userID, Guid accessToken, bool? forceVerify, string successRedirectUrl, string failureRedirectUrl, int? gameRegion) {
			return Get<string>(string.Format("linked-accounts/{0}", type) + string.Format("?userID={0}&accessToken={1}&forceVerify={2}&successRedirectUrl={3}&failureRedirectUrl={4}&gameRegion={5}",userID,accessToken,forceVerify,Uri.EscapeDataString(successRedirectUrl),Uri.EscapeDataString(failureRedirectUrl),gameRegion));
		}

		public ServiceResponse LinkAccount(AccountType type, LinkExternalAccountRequest request) {
			return Post(string.Format("linked-accounts/{0}", type), request);
		}

		public ServiceResponse UnlinkAccount(AccountType type, string accountID) {
			return Delete(string.Format("linked-accounts/links/{0}/{1}", type, accountID));
		}

		public ServiceResponse<AccountResyncResponse> Resync() {
			return Post<AccountResyncResponse>("linked-accounts/resync");
		}


    }
}
