using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class LoginService : BaseWebServiceClient
    {
        public LoginService(string url) : base(url)
        {
            
        }

		public ServiceResponse<LoginResponse> Login(LoginRequest loginRequest) {
			return Post<LoginResponse>("login", loginRequest);
		}

		public ServiceResponse<RenewTokenResponseContract> RenewToken() {
			return Post<RenewTokenResponseContract>("login/renew");
		}

		public ServiceResponse<LoginResponse> LoginWithNetworkSession(LoginWithNetworkSessionRequest request) {
			return Post<LoginResponse>("login/network-session", request);
		}

		public ServiceResponse<TwitchOAuthResponse> TwitchOAuth(TwitchOAuthRequest request) {
			return Post<TwitchOAuthResponse>("login/twitch-oauth", request);
		}

		public ServiceResponse<TwitchMergeResponse> TwitchMergeNew(TwitchMergeNewRequest request) {
			return Post<TwitchMergeResponse>("login/twitch-merge-new", request);
		}

		public ServiceResponse<TwitchMergeResponse> TwitchMergeExisting(TwitchMergeExistingRequest request) {
			return Post<TwitchMergeResponse>("login/twitch-merge-existing", request);
		}

		public ServiceResponse<TwitchMergeResponse> TwitchMergeTempAccount(TwitchMergeTempAccountRequest request) {
			return Post<TwitchMergeResponse>("login/twitch-merge-temp-account", request);
		}

		public ServiceResponse TwitchUnmerge(int twitchID) {
			return Post(string.Format("login/twitch-unmerge/{0}", twitchID));
		}

		public ServiceResponse<string> TestHmac(string username) {
			return Get<string>(string.Format("login/test-hmac/{0}", username));
		}

		public ServiceResponse<FuelAuthorizationResponseContract> GetFuelToken() {
			return Post<FuelAuthorizationResponseContract>("login/fuel");
		}


    }
}
