using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class SessionService : BaseWebServiceClient
    {
        public SessionService(string url) : base(url)
        {
            
        }

		public ServiceResponse<CreateSessionResponse> Create(CreateSessionRequest request) {
			return Post<CreateSessionResponse>("sessions", request);
		}

		public ServiceResponse Logout() {
			return Delete("sessions");
		}

		public ServiceResponse Update(Guid machineKey, UpdateDeviceTokensRequest request) {
			return Post(string.Format("sessions/{0}/tokens", machineKey), request);
		}

		public ServiceResponse Delete(Guid machineKey, string deviceID) {
			return Delete(string.Format("sessions/{0}/tokens/{1}", machineKey, deviceID));
		}

		public ServiceResponse UpdateCurrentGroup(Guid machineKey, UpdateCurrentGroupRequest request) {
			return Post(string.Format("sessions/{0}/group", machineKey), request);
		}


    }
}
