using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public enum AvatarType {
	User = 1,
	Group = 2,
	SyncedAccount = 3,
	SyncedCommunity = 4,
	GroupEmoticon = 5,
	SyncedEmoticon = 6,
	GroupCover = 7,
	TwitchEmote = 8,
	TwitchChatBadge = 9,
}
public enum CallMode {
	Audio = 1,
	Video = 2,
}
public enum ChangeUsernameStatus {
	Error = 0,
	Success = 1,
	InvalidPassword = 2,
	InvalidUsername = 3,
	UsernameInUse = 4,
	TooManyAttempts = 5,
}
public enum ClientCapability {
	Unknown = 0,
	All = -1,
	Whispers = 1,
	AudioCalls = 2,
	VideoCalls = 4,
	Groups = 8,
	Servers = 16,
	FileSharing = 32,
	ImageSharing = 64,
}
public enum ConversationNotificationType {
	Normal = 0,
	Edited = 1,
	Liked = 2,
	Deleted = 3,
}
public enum CreateGroupInvitationErrorType {
	NoRequest = 0,
	Success = 1,
	LifeSpanOutOfRange = 2,
	MaxUsesOutOfRange = 3,
	AdminDescriptionOutOfRange = 4,
	NotAServer = 5,
	WrongServer = 6,
	ChannelNotAccessibleByGuests = 7,
	TooManyInvites = 8,
}
public enum ExternalAccountChangeType {
	NeedsRelink = 0,
	Partnered = 1,
	Linked = 2,
	Unlinked = 3,
}
public enum ExternalCommunityLinkChangeType {
	Linked = 0,
	Unlinked = 1,
	LiveStatus = 2,
	InfoChanged = 3,
}
public enum ExternalCommunitySearchSortType {
	Default = 0,
	Title = 1,
	DateLive = 2,
}
public enum FriendRequestPrivacy {
	Anyone = 0,
	FriendsOfFriends = 1,
	NoOne = 2,
}
public enum CallResponseReason {
	Accepted = 0,
	Declined = 1,
}
public enum CallType {
	AdHoc = 1,
	AutoMatch = 2,
	Friend = 3,
	Group = 4,
	MultiFriend = 5,
}
public enum ContentTag {
	Image = 1,
	Video = 2,
	Hyperlink = 3,
	File = 4,
}
public enum ConversationEntryType {
	Message = 0,
	Notification = 1,
}
public enum ConversationType {
	Friendship = 0,
	Group = 1,
	AdHoc = 2,
	GroupPrivateConversation = 3,
}
public enum DevicePlatform {
	Windows = 0,
	Mac = 1,
	iOS = 2,
	Android = 3,
	WindowsPhone = 4,
	Blackberry = 5,
	Chrome = 6,
	Unknown = 7,
	Twitch = 8,
}
public enum EmoticonSource {
	Curse = 0,
	Twitch = 1,
}
public enum AccountType {
	Curse = 0,
	Twitch = 1,
	YouTube = 2,
	WorldOfWarcraft = 3,
}
public enum FriendHintStatus {
	Normal = 0,
	Deleted = 1,
}
public enum FriendHintType {
	Unknown = 0,
	CentralID = 1,
	Username = 2,
	Email = 3,
	Site = 4,
	Game = 5,
	Platform = 6,
}
public enum FriendHintVerification {
	Unknown = 0,
	ManualEntry = 1,
	ClientSubmitted = 100,
	ClientObserved = 200,
	Verified = 300,
}
public enum FriendHintVisibility {
	VisibleToFriends = 0,
	VisibleToEveryone = 1,
	Hidden = 2,
}
public enum FriendPlatform {
	Unknown = 0,
	BattleNet = 1,
	Steam = 2,
	Facebook = 3,
	Skype = 4,
}
public class FriendPlatformExtensions{
}
public enum FriendshipRequestAvailability {
	Allowed = 0,
	NotAllowed = 1,
	NoMutualFriends = 2,
}
public enum FriendshipStatus {
	AwaitingMe = 0,
	AwaitingThem = 1,
	Confirmed = 2,
	DeclinedByMe = 3,
	DeclinedByThem = 4,
	Removing = 5,
	Deleted = 6,
}
public enum FriendSuggestionType {
	MutualFriend = 0,
	GameFriend = 1,
	PlatformFriend = 2,
}
public enum FriendSuggestionStatus {
	Pending = 0,
	Declined = 1,
	Accepted = 2,
}
public enum GroupBannedUserSortType {
	Username = 0,
	Date = 1,
	Reason = 2,
	Requestor = 3,
}
public enum GroupChangeType {
	Unknown = 0,
	CreateGroup = 1,
	AddUsers = 2,
	RemoveUsers = 3,
	UpdateUsers = 4,
	ChangeInfo = 5,
	VoiceSessionStarted = 6,
	VoiceSessionEnded = 7,
	VoiceSessionUserJoined = 8,
	VoiceSessionUserLeft = 9,
	RemoveGroup = 10,
	GroupReorganized = 11,
	PermissionsChanged = 12,
	RoleNamesChanged = 13,
	UpdateEmoticons = 14,
	UpdateUserPresence = 15,
}
public enum GroupEventChannelChangeFlags {
	None = 0,
	Title = 1,
	Motd = 2,
	Permissions = 4,
	Access = 8,
}
public enum GroupEventCommunityChangeFlags {
	None = 0,
	SyncEmotes = 1,
	GracePeriod = 2,
}
public enum GroupEventRoleChangeFlags {
	None = 0,
	Name = 1,
	Rank = 2,
	Permissions = 4,
	Color = 8,
	Badge = 16,
}
public enum GroupEventRootChangeFlags {
	None = 0,
	Title = 1,
	Motd = 2,
	VoiceRegion = 4,
	AfkTimer = 8,
	Access = 16,
	ChatThrottle = 32,
	SearchSettings = 64,
}
public enum GroupEventSearchSortType {
	Timestamp = 0,
	InitiatingUsername = 1,
	Category = 2,
	EventType = 3,
}
public enum GroupEventCategory {
	Group = 0,
	User = 1,
	Giveaway = 2,
	Poll = 3,
	CommunityLink = 4,
	Role = 5,
	Channel = 6,
	GuildLink = 7,
}
public enum GroupEventType {
	GroupCreated = 1,
	GroupDeleted = 2,
	GroupSettingsChanged = 3,
	UsersAdded = 2001,
	UsersRemoved = 2002,
	UserRolesAdded = 2003,
	UserRolesRemoved = 2004,
	UserNickname = 2005,
	GiveawayStarted = 3001,
	GiveawayRoll = 3002,
	GiveawayEnded = 3003,
	PollStarted = 4001,
	PollEnded = 4002,
	CommunityLinked = 5001,
	CommunityUnlinked = 5002,
	CommunitySettingsChanged = 5003,
	ChannelCreated = 6001,
	ChannelRemoved = 6002,
	ChannelInfoChanged = 6003,
	RoleAdded = 7001,
	RoleRemoved = 7002,
	RoleInfoChanged = 7003,
	GuildLinked = 8001,
	GuildUnlinked = 8002,
}
public enum GroupGiveawayChangeType {
	Unknown = 0,
	Started = 1,
	Ended = 2,
	Removed = 3,
	ParticipantAdded = 4,
	ParticipantRemoved = 5,
	WinnerSelected = 6,
	InvalidWinnerSelected = 7,
	PrizeClaimed = 8,
	ClaimExpired = 9,
	EntriesUpdated = 10,
	InvalidRoll = 11,
	FakeRoll = 12,
	Rolling = 13,
}
public enum GroupGiveawayRollStatus {
	Pending = 0,
	Invalid = 1,
	Claimed = 2,
	ClaimExpired = 3,
	Fake = 4,
}
public enum GroupGiveawayStatus {
	Active = 0,
	Rolling = 1,
	WaitingForClaim = 2,
	Claimed = 3,
	Ended = 4,
	Inactive = 5,
}
public enum GroupGiveawayWinnerValidStatus {
	Unknown = 0,
	Valid = 1,
	MissingRole = 2,
	Offline = 3,
	FakeRoll = 4,
	NoMembership = 5,
}
public enum GroupInvitationStatus {
	Active = 0,
	Invalid = 1,
	Defunct = 2,
}
public enum GroupMemberNicknameStatus {
	Invalid = 0,
	ModeratorName = 1,
	Throttled = 2,
	Success = 3,
}
public enum GroupMemberSearchSortType {
	Default = 0,
	Role = 1,
	Username = 2,
	DateJoined = 3,
	DateLastActive = 4,
}
public enum GroupMembershipStatus {
	Subscribed = 0,
	Unsubscribed = 1,
}
public enum GroupMode {
	TextAndVoice = 0,
	TextOnly = 1,
}
public enum GroupPermissions {
	None = 0,
	All = -1,
	Access = 1,
	ManageServer = 2,
	ManageChannels = 4,
	CreateTemporaryGroup = 8,
	AccessAdminPanel = 16,
	InviteUsers = 32,
	RemoveUser = 64,
	ManageInvitations = 128,
	ChangeUserRole = 256,
	BanUser = 512,
	VoiceKickUser = 1024,
	VoiceMuteUser = 2048,
	VoiceDeafenUser = 4096,
	VoiceSpeak = 8192,
	VoiceMoveUser = 16384,
	VoiceChangeSettings = 32768,
	ChatSendMessages = 65536,
	ChatEmbedLinks = 131072,
	ChatUploadPhotos = 262144,
	ChatAttachFiles = 524288,
	ChatReadHistory = 1048576,
	ChatMentionUsers = 2097152,
	ChatMentionEveryone = 4194304,
	ChatBypassChatThrottle = 268435456,
	ChatModerateMessages = 8388608,
	SendPrivateMessage = 16777216,
	ManagePolls = 33554432,
	ManageGiveaways = 67108864,
	ChatEditOtherMessages = 134217728,
}
public enum GroupPermissionState {
	Allowed = 0,
	AllowedInherited = 1,
	NotAllowed = 2,
	NotAllowedInherited = 3,
}
public enum GroupPollChangeType {
	Started = 0,
	Ended = 1,
	VotesUpdated = 2,
	Deactivated = 3,
}
public enum GroupPollDisplayType {
	BarGraph = 0,
	PieChart = 1,
}
public enum GroupPollDuplicateMode {
	Legacy = 0,
	PreventByUserID = 1,
	PreventByIP = 2,
	PreventByCookie = 3,
	AllowDuplicates = 4,
}
public enum GroupPollStatus {
	Starting = 0,
	Running = 1,
	Ended = 2,
	Inactive = 3,
}
public enum GroupMemberRemovedReason {
	Left = 0,
	Kicked = 1,
	Banned = 2,
}
public enum GroupRoleSource {
	Curse = 0,
	Twitch = 1,
	YouTube = 2,
}
public enum GroupRoleTag {
	None = 0,
	SyncedFollower = 1,
	SyncedSubscriber = 2,
	SyncedModerator = 3,
	SyncedOwner = 4,
	GuildMasterRank = 5,
	GuildRank1 = 6,
	GuildRank2 = 7,
	GuildRank3 = 8,
	GuildRank4 = 9,
	GuildRank5 = 10,
	GuildRank6 = 11,
	GuildRank7 = 12,
	GuildRank8 = 13,
	GuildRank9 = 14,
	SyncedSubscriberTier2 = 15,
	SyncedSubscriberTier3 = 16,
}
public enum GroupSearchSortType {
	Default = 0,
	Title = 1,
	MemberCount = 2,
	DateStreaming = 3,
	DateFeatured = 4,
}
public enum GroupSearchTag {
	Casual = 0,
	Hardcore = 1,
	Competitive = 2,
	LFM = 3,
	Twitch = 4,
	YouTube = 5,
	Guild = 6,
	Azubu = 7,
}
public enum GroupSubType {
	Custom = 0,
	Guild = 1,
	Stream = 2,
	WowNeutral = 3,
	WowAlliance = 4,
	WowHorde = 5,
}
public enum GroupSuggestionStatus {
	Pending = 0,
	Declined = 1,
	Accepted = 2,
	Invalid = 3,
}
public enum GroupSuggestionType {
	ExternalAccountSync = 0,
}
public enum GuildServerCreationErrorType {
	NoError = 0,
	TitleLength = 1,
	OwnerRoleMissing = 2,
	OwnerRoleNameLength = 3,
	GuestRoleMissing = 4,
	GuestRoleNameLength = 5,
	AdditionalRoleNameLength = 6,
	GeneralChatNameLength = 7,
	OfficerChatNameLength = 8,
	PveChatNameLength = 9,
	PvpChatNameLength = 10,
	DefaultVoiceChatNameLength = 11,
	SyncedGuildCount = 12,
	SyncedGuildNameLength = 13,
	SyncedGuildRegion = 14,
	SyncedGuildGameServerLength = 15,
}
public enum IdentityMergeStatus {
	Unmerged = 0,
	AutoProvisioned = 1,
	Merged = 2,
	Failed = 3,
}
public enum IdentityMergeFailureReason {
	GeneralError = 0,
	ValidationError = 1,
	UnknownUser = 2,
	InvalidPassword = 3,
	CurseAccountMerged = 4,
	TwitchAccountMerged = 5,
	DeletedAccount = 6,
	ApiError = 7,
}
public enum GroupStatus {
	Normal = 0,
	Deleted = 1,
}
public enum GroupType {
	Normal = 0,
	Large = 1,
	Temporary = 2,
}
public enum HostEnvironment {
	Unknown = 0,
	Debug = 1,
	Staging = 2,
	Beta = 3,
	Release = 4,
}
public enum MessageForbiddenReason {
	Unknown = 0,
	NotAttachmentOwner = 1,
	NotFamiliar = 100,
	PrivateMessagingBanned = 101,
	PrivateMessagingRecipientBanned = 102,
	PrivateMessagingSenderBlockedRecipient = 103,
	PrivateMessagingRecipientBlockedSender = 104,
	MissingPermission = 200,
	UnsupportedCommand = 201,
	InvalidChannel = 202,
	NoLinkedAccount = 203,
	LinkedAccountNeedsReauth = 204,
}
public enum NotificationPreference {
	Enabled = 0,
	Disabled = 1,
	Filtered = 2,
}
public enum PresenceActivityType {
	Playing = 0,
	Watching = 1,
	Broadcasting = 2,
}
public enum PrivateMessagePrivacy {
	Anyone = 0,
	FriendsOnly = 1,
	OnlyContactedUsers = 2,
}
public enum PushNotificationPreference {
	All = 0,
	Favorites = 1,
	None = 2,
}
public enum PushNotificationType {
	Unknown = 0,
	InstantMessage = 1,
	GroupMessage = 2,
	FriendRequest = 3,
	FriendConfirmation = 4,
	IncomingCall = 5,
	ConversationMessage = 6,
}
public enum ShareActivityPrivacy {
	Share = 0,
	Hide = 1,
}
public enum SpamConfidence {
	Unknown = 0,
	Low = 1,
	Medium = 2,
	High = 3,
}
public enum UserBanType {
	Global = -1,
	None = 0,
	Social = 1,
	Whisper = 2,
}
public enum UserBlockStatus {
	Active = 0,
	Inactive = 1,
}
public enum UserReportReason {
	BitViolation = 0,
	ChatBanEvasion = 1,
	Cheating = 2,
	CreativeConduct = 3,
	Gore = 4,
	Harassment = 5,
	Harm = 6,
	HateSpeech = 7,
	Impersonation = 8,
	MusicConduct = 9,
	Nongaming = 10,
	OffensiveUsername = 11,
	Other = 12,
	Porn = 13,
	Prohibited = 14,
	SelfHarm = 15,
	SocialEatingViolation = 16,
	Spam = 17,
	TosBanEvasion = 18,
	Underaged = 19,
}
public enum UserReportType {
	Whisper = 0,
	PublicGroup = 1,
	PrivateGroup = 2,
}
public enum SyncedMemberGracePeriodAction {
	None = 0,
	RemoveRoles = 1,
	RemoveMember = 2,
}
public enum TwitchChatNoticeType {
	Unknown = 0,
	AuthenticationFailed = 1,
	UserTimedOut = 2,
	UserSubscribed = 3,
	ChatCleared = 4,
	Resub = 5,
	Sub = 6,
	WhisperBanned = 101,
	WhisperBannedRecipient = 102,
	WhisperInvalidArgs = 103,
	WhisperInvalidLogin = 104,
	WhisperInvalidSelf = 105,
	WhisperLimitPerMin = 106,
	WhisperLimitPerSec = 107,
	WhisperRestricted = 108,
	WhisperRestrictedRecipient = 109,
	SubsOnlyOn = 201,
	SubsOnlyOff = 202,
	EmoteOnlyOn = 203,
	EmoteOnlyOff = 204,
	SlowModeOn = 205,
	SlowModeOff = 206,
	R9KOn = 207,
	R9KOff = 208,
	HostOn = 209,
	HostOff = 210,
	HostTargetWentOffline = 211,
	FollowersOnlyOn = 212,
	FollowersOnlyOff = 213,
	FollowersOnlyOnZero = 214,
	UnrecognizedCommand = 301,
	NoHelp = 302,
	UsageMe = 303,
	UsageHelp = 304,
	UsageDisconnect = 305,
	UsageMods = 306,
	UsageSubsOn = 307,
	UsageSubsOff = 308,
	UsageEmoteOnlyOn = 309,
	UsageEmoteOnlyOff = 310,
	UsageSlowOn = 311,
	UsageSlowOff = 312,
	UsageR9kOn = 313,
	UsageR9kOff = 314,
	UsageClear = 315,
	UsageColor = 316,
	UsageCheerBadge = 317,
	UsageTimeout = 318,
	UsageMod = 319,
	UsageUnmod = 320,
	UsageBan = 321,
	UsageUnban = 322,
	UsageHost = 323,
	UsageUnhost = 324,
	UsageCommercial = 325,
	UsageUntimeout = 326,
	CmdsAvailable = 401,
	NoMods = 402,
	RoomMods = 403,
	NoPermission = 404,
	AlreadySubsOn = 405,
	AlreadySubsOff = 406,
	AlreadyEmoteOnlyOn = 407,
	AlreadyEmoteOnlyOff = 408,
	AlreadyR9kOn = 409,
	AlreadyR9kOff = 410,
	TurboOnlyColor = 411,
	ColorChanged = 412,
	CheerBadgeDeselected = 413,
	CheerBadgeSelected = 414,
	NoCheerBadge = 415,
	InvalidUser = 416,
	BadTimeoutAnon = 501,
	BadTimeoutBroadcaster = 502,
	BadTimeoutStaff = 503,
	BadTimeoutAdmin = 504,
	BadTimeoutGlobalMod = 505,
	BadTimeoutSelf = 506,
	BadTimeoutMod = 507,
	BadTimeoutDuration = 508,
	TimeoutSuccess = 509,
	UntimeoutSuccess = 510,
	UntimeoutIsBanned = 511,
	TimeoutNoTimeout = 512,
	BadBanAnon = 601,
	BadBanBroadcaster = 602,
	BadBanStaff = 603,
	BadBanAdmin = 604,
	BadBanGlobalMod = 605,
	BadBanSelf = 606,
	BadBanMod = 607,
	BadUnbanNoBan = 608,
	AlreadyBanned = 609,
	BanSuccess = 610,
	UnbanSuccess = 611,
	TosBanned = 612,
	BadHostSelf = 701,
	BadHostHosting = 702,
	BadHostRejected = 703,
	BadHostRateExceeded = 704,
	BadHostError = 705,
	HostsRemaining = 706,
	HostSuccess = 707,
	HostSuccessViewers = 708,
	NotHosting = 709,
	BadUnhostError = 710,
	HostTaglineLengthError = 711,
	BadCommercialError = 801,
	CommercialSuccess = 802,
	BadModBanned = 901,
	BadModMod = 902,
	ModSuccess = 903,
	BadUnmodMod = 904,
	UnmodSuccess = 905,
	BadSlowDuration = 1001,
	MessageBanned = 1101,
	MessageTimedOut = 1102,
	MessageRateLimit = 1103,
	MessageDuplicate = 1104,
	MessageSubsOnly = 1105,
	MessageEmotesOnly = 1106,
	MessageVerifiedEmail = 1107,
	MessageSlowMode = 1108,
	MessageFacebook = 1109,
	MessageR9k = 1110,
	MessageConversationMode = 1111,
	MessageChannelSuspended = 1112,
	MessageSuspended = 1113,
	MessageRejected = 1114,
}
public enum UserConnectionStatus {
	Offline = 0,
	Online = 1,
	Away = 2,
	Invisible = 3,
	Idle = 4,
	DoNotDisturb = 5,
}
public enum UserTrackingType {
	Unknown = 0,
	PartnerServerUpsell = 1,
}
public enum VoiceRegion {
	Default = 0,
	NorthAmericaEast = 1,
	NorthAmericaWest = 2,
	EuropeWest = 3,
	AsiaSouth = 4,
	AsiaNorth = 5,
	Oceania = 6,
	SouthAmerica = 7,
	CanadaEast = 8,
	EuropeNordicAndEast = 10,
}
public enum BattleNetRegion {
	US = 1,
	EU = 2,
	KR = 3,
	TW = 4,
	CN = 5,
}

}
