using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class ActiveGiveawayResponse{
	public GroupGiveawayNotification Giveaway { get; set; }
	public GroupGiveawayRollContract[] Rolls { get; set; }
	public PendingWinnerContract PendingWinner { get; set; }
	public bool Entered { get; set; }
}
public class PendingWinnerContract{
	public Guid GroupID { get; set; }
	public int GiveawayID { get; set; }
	public int UserID { get; set; }
	public string Username { get; set; }
	public int SecondsUntilExpires { get; set; }
	public long Timestamp { get; set; }
}
public class CreateGiveawayRequest{
	public string Title { get; set; }
	public bool AutoEnterActiveUsers { get; set; }
	public int[] AutoEnterRoles { get; set; }
	public int[] AutoClaimRoles { get; set; }
	public int RollsBeforeWinner { get; set; }
	public Dictionary<int, int>  RoleBonuses { get; set; }
	public int ResponseWindowSeconds { get; set; }
	public int[] RequiredRoles { get; set; }
	public bool AllowRepeatWinners { get; set; }
	public int[] IgnoredUsers { get; set; }
	public int SharingBonus { get; set; }
	public bool IncludeOfflineMembers { get; set; }
}
public class GroupGiveawayRollResult{
	public Guid GroupID { get; set; }
	public int GiveawayID { get; set; }
	public string Title { get; set; }
	public long RollTimestamp { get; set; }
	public int TotalEntries { get; set; }
	public int WinnerUserID { get; set; }
	public string WinnerUsername { get; set; }
	public bool ValidWinner { get; set; }
	public bool ClaimedPrize { get; set; }
}
public class GetGiveawayHistoryRequest{
	public int? PageSize { get; set; }
	public int? PageNumber { get; set; }
}

}
