using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class AttachmentNotification{
	public string ID { get; set; }
	public string ConversationID { get; set; }
	public string MessageID { get; set; }
	public string Name { get; set; }
	public string Title { get; set; }
	public long Size { get; set; }
	public string FileType { get; set; }
	public string Url { get; set; }
	public int Width { get; set; }
	public int Height { get; set; }
	public bool IsAnimated { get; set; }
	public bool IsEmbed { get; set; }
	public int AuthorID { get; set; }
	public string AuthorName { get; set; }
	public long Timestamp { get; set; }
	public int RegionID { get; set; }
}
public class BlockedUserContract{
	public int UserID { get; set; }
	public string Username { get; set; }
	public string DisplayName { get; set; }
}
public class ChannelMembershipContract{
	public DateTime DateMessaged { get; set; }
	public DateTime DateRead { get; set; }
	public int UnreadCount { get; set; }
	public bool IsFavorite { get; set; }
	public NotificationPreference NotificationPreference { get; set; }
	public string[] NotificationFilters { get; set; }
	public DateTime NotificationMuteDate { get; set; }
}
public class ConversationMessageBadgeContract{
	public string BadgeSet { get; set; }
	public string Version { get; set; }
	public string Description { get; set; }
	public string Title { get; set; }
	public string ClickAction { get; set; }
	public string ClickUrl { get; set; }
}
public class ExternalAccountChangedNotification{
	public ExternalAccountChangeType ChangeType { get; set; }
	public ExternalAccountContract Account { get; set; }
}
public class ExternalAccountPublicContract{
	public string ExternalID { get; set; }
	public string ExternalName { get; set; }
	public string ExternalDisplayName { get; set; }
	public AccountType Type { get; set; }
}
public class ExternalCommunityLinkChangedNotification{
	public ExternalCommunityLinkChangeType ChangeType { get; set; }
	public GroupNotification Group { get; set; }
	public ExternalCommunityPublicContract Community { get; set; }
}
public class ExternalCommunitySearchModelContract{
	public AccountType Type { get; set; }
	public string ExternalID { get; set; }
	public string ExternalName { get; set; }
	public string ExternalDisplayName { get; set; }
	public string AvatarUrl { get; set; }
	public string ExternalStatus { get; set; }
	public string ExternalGameName { get; set; }
	public bool IsLive { get; set; }
	public long LiveTimestamp { get; set; }
	public string ExternalUrl { get; set; }
	public int Followers { get; set; }
	public int SortRank { get; set; }
}
public class ExternalGuildContract{
	public AccountType Type { get; set; }
	public int GameRegion { get; set; }
	public string GameServer { get; set; }
	public string Name { get; set; }
	public int Faction { get; set; }
	public int Level { get; set; }
	public int MemberCount { get; set; }
	public string GuildMasterGameServer { get; set; }
	public string GuildMasterName { get; set; }
	public int AchievementPoints { get; set; }
	public ExternalGuildEmblemContract Emblem { get; set; }
}
public class ExternalGuildEmblemContract{
	public string BackgroundColor { get; set; }
	public int Border { get; set; }
	public string BorderColor { get; set; }
	public int Icon { get; set; }
	public string IconColor { get; set; }
}
public class GroupBulkMessageDeleteNotification{
	public Guid GroupID { get; set; }
	public int UserID { get; set; }
	public long StartMessageTimestamp { get; set; }
	public long EndMessageTimestamp { get; set; }
	public int DeletingUserID { get; set; }
	public string DeletingUserName { get; set; }
}
public class PrivateConversationContract{
	public int OtherUserID { get; set; }
	public string ConversationID { get; set; }
	public string Title { get; set; }
	public DateTime DateMessaged { get; set; }
	public DateTime DateRead { get; set; }
	public int UnreadCount { get; set; }
}
public class TwitchChatNoticeNotification{
	public string ExternalChannelID { get; set; }
	public TwitchChatNoticeType NoticeType { get; set; }
	public string NoticeText { get; set; }
	public long DurationSeconds { get; set; }
	public long Timestamp { get; set; }
	public string ExternalUserID { get; set; }
	public string ExternalUsername { get; set; }
}
public class GroupEventContract{
	public Guid RootGroupID { get; set; }
	public GroupEventCategory Category { get; set; }
	public GroupEventType Type { get; set; }
	public long Timestamp { get; set; }
	public int InitiatingUserID { get; set; }
	public string InitiatingUsername { get; set; }
	public GroupEventRootChangeFlags RootChangeFlags { get; set; }
	public GroupEventGroupContract PreviousRootGroupDetails { get; set; }
	public GroupEventGroupContract RootGroupDetails { get; set; }
	public GroupEventChannelChangeFlags ChannelChangeFlags { get; set; }
	public GroupEventChannelContract PreviousChannelDetails { get; set; }
	public GroupEventChannelContract ChannelDetails { get; set; }
	public GroupEventRoleChangeFlags RoleChangeFlags { get; set; }
	public GroupEventRoleContract PreviousRoleDetails { get; set; }
	public GroupEventRoleContract RoleDetails { get; set; }
	public GroupEventCommunityChangeFlags LinkedCommunityChangeFlags { get; set; }
	public GroupEventLinkedCommunityContract PreviousLinkedCommunityDetails { get; set; }
	public GroupEventLinkedCommunityContract LinkedCommunityDetails { get; set; }
	public GroupEventUserContract MemberDetails { get; set; }
	public GroupEventGiveawayContract GiveawayDetails { get; set; }
	public GroupEventPollContract PollDetails { get; set; }
}
public class GroupEventUserContract{
	public int UserID { get; set; }
	public string Username { get; set; }
	public int RoleID { get; set; }
	public string RoleName { get; set; }
	public GroupMemberRemovedReason? RemovedReason { get; set; }
	public string RemovedMessage { get; set; }
}
public class GroupEventGroupContract{
	public string Title { get; set; }
	public string MessageOfTheDay { get; set; }
	public int VoiceRegion { get; set; }
	public int AfkTimerMinutes { get; set; }
	public bool IsPublic { get; set; }
	public bool ChatThrottleEnabled { get; set; }
	public int ChatThrottleSeconds { get; set; }
	public bool IsSearchable { get; set; }
	public int[] SearchTags { get; set; }
	public int[] SearchGames { get; set; }
	public bool MatchAllGames { get; set; }
	public string SearchDescription { get; set; }
}
public class GroupEventChannelContract{
	public Guid ChannelID { get; set; }
	public string Title { get; set; }
	public string MessageOfTheDay { get; set; }
	public GroupType Type { get; set; }
	public bool IsPublic { get; set; }
	public int[] AccessRoles { get; set; }
	public int RoleID { get; set; }
	public string RoleName { get; set; }
	public Dictionary<int, int>  PermissionsStates { get; set; }
	public GroupMode Mode { get; set; }
}
public class GroupEventRoleContract{
	public int RoleID { get; set; }
	public string Name { get; set; }
	public int Color { get; set; }
	public int Badge { get; set; }
	public int Rank { get; set; }
	public GroupPermissions Permissions { get; set; }
}
public class GroupEventPollContract{
	public int PollID { get; set; }
	public string Title { get; set; }
	public int TotalVotes { get; set; }
	public int[] RequiredRoles { get; set; }
	public int OptionsCount { get; set; }
	public string[] WinningOptions { get; set; }
	public int DurationMinutes { get; set; }
}
public class GroupEventGiveawayContract{
	public int GiveawayID { get; set; }
	public string Title { get; set; }
	public int Entries { get; set; }
	public int RollNumber { get; set; }
	public GroupGiveawayRollStatus? RollStatus { get; set; }
	public int WinnerUserID { get; set; }
	public string WinnerUsername { get; set; }
	public int WinnerBestRoleID { get; set; }
	public string WinnerBestRoleName { get; set; }
	public GroupGiveawayWinnerValidStatus? WinnerValidStatus { get; set; }
}
public class GroupEventLinkedCommunityContract{
	public string ExternalID { get; set; }
	public string ExternalName { get; set; }
	public bool SyncEmoticons { get; set; }
	public SyncedMemberGracePeriodAction? GracePeriodAction { get; set; }
	public int GracePeriodDays { get; set; }
	public bool IsStreaming { get; set; }
}
public class CallNotification{
	public string HostName { get; set; }
	public string IpAddress { get; set; }
	public long AccessToken { get; set; }
	public int HostID { get; set; }
	public string RegionName { get; set; }
	public string InviteUrl { get; set; }
	public string InviteCode { get; set; }
	public CallType CallType { get; set; }
	public string CallID { get; set; }
	public string ConversationID { get; set; }
	public int CreatorID { get; set; }
	public string CreatorName { get; set; }
	public int? GameID { get; set; }
	public long? AutoMatchKey { get; set; }
	public DateTime Timestamp { get; set; }
	public int SenderID { get; set; }
	public string SenderName { get; set; }
	public bool ForceJoin { get; set; }
	public CallMode Mode { get; set; }
}
public class CallRespondedNotification{
	public string CallID { get; set; }
	public string InviteCode { get; set; }
	public string InviteUrl { get; set; }
	public CallResponseReason Reason { get; set; }
	public int UserID { get; set; }
	public string Username { get; set; }
	public DateTime Timestamp { get; set; }
}
public class ChannelContract{
	public string GroupTitle { get; set; }
	public Guid GroupID { get; set; }
	public Guid ParentGroupID { get; set; }
	public Guid RootGroupID { get; set; }
	public string VoiceSessionCode { get; set; }
	public string MessageOfTheDay { get; set; }
	public GroupMode GroupMode { get; set; }
	public GroupType GroupType { get; set; }
	public GroupStatus GroupStatus { get; set; }
	public int DisplayOrder { get; set; }
	public Guid DisplayCategoryID { get; set; }
	public string DisplayCategory { get; set; }
	public int DisplayCategoryRank { get; set; }
	public bool AllowTemporaryChildGroups { get; set; }
	public bool ForcePushToTalk { get; set; }
	public bool IsDefaultChannel { get; set; }
	public Dictionary<int, long>  RolePermissions { get; set; }
	public bool IsPublic { get; set; }
	public ChannelMembershipContract Membership { get; set; }
	public string UrlPath { get; set; }
	public GroupMemberContract[] VoiceMembers { get; set; }
	public bool HideNoAccess { get; set; }
	public bool HideCallMembersNoAccess { get; set; }
	public string ExternalChannelID { get; set; }
}
public class CharacterSearchContract{
	public Double Score { get; set; }
	public string SearchTerm { get; set; }
	public string CharacterName { get; set; }
	public string ServerName { get; set; }
	public string ServerRegion { get; set; }
	public string UniqueKey { get; set; }
	public int UserID { get; set; }
	public int GameID { get; set; }
	public int FriendCount { get; set; }
	public string Description { get; set; }
	public string AvatarUrl { get; set; }
	public FriendshipRequestAvailability FriendshipAvailability { get; set; }
}
public class ConversationMessageResponse{
	public string ConversationID { get; set; }
	public DeliveryStatus Status { get; set; }
	public Guid ClientID { get; set; }
	public Guid ServerID { get; set; }
	public long? RetryAfter { get; set; }
	public MessageForbiddenReason ForbiddenReason { get; set; }
	public GroupPermissions MissingPermission { get; set; }
}
public class ConversationMessageRequest{
	public string ConversationID { get; set; }
	public Guid AttachmentID { get; set; }
	public Guid ClientID { get; set; }
	public string Message { get; set; }
	public int AttachmentRegionID { get; set; }
}
public class ConversationMessageNotification{
	public string ClientID { get; set; }
	public string ServerID { get; set; }
	public string ConversationID { get; set; }
	public string ContactID { get; set; }
	public ConversationType ConversationType { get; set; }
	public string RootConversationID { get; set; }
	public long Timestamp { get; set; }
	public int SenderID { get; set; }
	public string SenderName { get; set; }
	public string SenderUsername { get; set; }
	public string SenderDisplayName { get; set; }
	public long SenderPermissions { get; set; }
	public int[] SenderRoles { get; set; }
	public int SenderVanityRole { get; set; }
	public int[] Mentions { get; set; }
	public int RecipientID { get; set; }
	public string Body { get; set; }
	public bool IsDeleted { get; set; }
	public long DeletedTimestamp { get; set; }
	public int DeletedUserID { get; set; }
	public string DeletedUsername { get; set; }
	public long EditedTimestamp { get; set; }
	public int EditedUserID { get; set; }
	public string EditedUsername { get; set; }
	public int LikeCount { get; set; }
	public int[] LikeUserIDs { get; set; }
	public string[] LikeUsernames { get; set; }
	public int[] ContentTags { get; set; }
	public AttachmentNotification[] Attachments { get; set; }
	public ConversationNotificationType NotificationType { get; set; }
	public ConversationMessageEmoteSubstitutionNotification[] EmoteSubstitutions { get; set; }
	public SpamConfidence SpamConfidence { get; set; }
	public string ExternalChannelID { get; set; }
	public string ExternalUserID { get; set; }
	public string ExternalUsername { get; set; }
	public string ExternalUserDisplayName { get; set; }
	public string ExternalUserColor { get; set; }
	public ConversationMessageBadgeContract[] Badges { get; set; }
	public int BitsUsed { get; set; }
}
public class ConversationMessageEmoteSubstitutionNotification{
	public string MessageText { get; set; }
	public long EmoteID { get; set; }
	public int EmoteSet { get; set; }
	public int StartIndex { get; set; }
	public int EndIndex { get; set; }
	public int EmoteHeight { get; set; }
	public int EmoteWidth { get; set; }
}
public class ConversationReadNotification{
	public Guid GroupID { get; set; }
	public int FriendID { get; set; }
	public DateTime Timestamp { get; set; }
	public string ConversationID { get; set; }
	public bool MarkAllAsRead { get; set; }
}
public class EmailSearchContract{
	public Double Score { get; set; }
	public string EmailAddress { get; set; }
	public int UserID { get; set; }
	public int FriendCount { get; set; }
	public string AvatarUrl { get; set; }
	public FriendshipRequestAvailability FriendshipAvailability { get; set; }
	public bool IsMerged { get; set; }
}
public class ExternalAccountContract{
	public string ExternalID { get; set; }
	public string ExternalName { get; set; }
	public string ExternalDisplayName { get; set; }
	public AccountType Type { get; set; }
	public bool IsPartnered { get; set; }
	public long DateLinked { get; set; }
	public bool EligibleForVanityUrl { get; set; }
	public bool NeedsReauthentication { get; set; }
}
public class ExternalCommunityContract{
	public string ExternalID { get; set; }
	public AccountType Type { get; set; }
	public string ExternalName { get; set; }
	public string ExternalDisplayName { get; set; }
	public long CreatedTimestamp { get; set; }
	public bool IsPartnered { get; set; }
	public int Followers { get; set; }
	public int Subscribers { get; set; }
	public int GameID { get; set; }
	public string ExternalGameName { get; set; }
	public string ExternalStatus { get; set; }
	public string ExternalUrl { get; set; }
	public bool IsAffiliate { get; set; }
}
public class ExternalCommunityLinkContract{
	public ExternalCommunityContract Community { get; set; }
	public Guid GroupID { get; set; }
	public bool SyncEmotes { get; set; }
	public bool SyncEvents { get; set; }
	public SyncedMemberGracePeriodAction GracePeriodAction { get; set; }
	public int GracePeriodDays { get; set; }
	public int SyncedPremiumMembers { get; set; }
	public bool IsLive { get; set; }
}
public class ExternalCommunityEmoticonContract{
	public AccountType CommunityType { get; set; }
	public string SyncID { get; set; }
	public string Regex { get; set; }
	public GroupRoleTag[] RequiredRoles { get; set; }
}
public class ExternalCommunityMemberContract{
	public string ExternalUserID { get; set; }
	public string ExternalUsername { get; set; }
	public string ExternalUserDisplayName { get; set; }
	public string ExternalCommunityID { get; set; }
	public string ExternalCommunityName { get; set; }
	public AccountType ExternalCommunityType { get; set; }
	public GroupRoleTag ExternalCommunityRole { get; set; }
	public bool ExternalRoleIsActive { get; set; }
	public long ExternalRoleFirstTimestamp { get; set; }
	public long ExternalRoleCurrentTimestamp { get; set; }
	public int ExternalRoleEntryNumber { get; set; }
	public Guid GroupID { get; set; }
	public int UserID { get; set; }
	public string Username { get; set; }
	public int[] GroupRoles { get; set; }
	public GroupMemberContract GroupMember { get; set; }
}
public class FriendHintContract{
	public long ID { get; set; }
	public int UserID { get; set; }
	public string SearchTerm { get; set; }
	public FriendHintType Type { get; set; }
	public int GameID { get; set; }
	public string Region { get; set; }
	public string Server { get; set; }
	public string Site { get; set; }
	public FriendPlatform Platform { get; set; }
	public string DisplayName { get; set; }
	public string AvatarUrl { get; set; }
	public string Description { get; set; }
	public FriendHintVerification Verification { get; set; }
	public FriendHintStatus Status { get; set; }
	public FriendHintVisibility Visibility { get; set; }
}
public class FriendshipChangeNotification{
	public FriendshipContract Friendship { get; set; }
}
public class FriendSuggestionContract{
	public int FriendID { get; set; }
	public string Username { get; set; }
	public string AvatarUrl { get; set; }
	public int FriendCount { get; set; }
	public FriendSuggestionType Type { get; set; }
	public int GameID { get; set; }
	public FriendPlatform Platform { get; set; }
	public long SuggestedTimestamp { get; set; }
	public int[] FriendIDs { get; set; }
}
public class FriendSuggestionNotification{
	public FriendSuggestionContract[] Suggestions { get; set; }
}
public class GroupCallMemberListContract{
	public Guid GroupID { get; set; }
	public GroupMemberContract CallMembers { get; set; }
}
public class GroupChangeNotification{
	public GroupChangeType ChangeType { get; set; }
	public int SenderID { get; set; }
	public string SenderName { get; set; }
	public GroupNotification Group { get; set; }
	public GroupMemberContract[] Members { get; set; }
	public DateTime TimeStamp { get; set; }
	public ChannelContract[] ChildGroups { get; set; }
	public GroupMemberRemovedReason RemovedReason { get; set; }
	public string MessageToUsers { get; set; }
}
public class GroupEmoticonNotification{
	public Guid GroupID { get; set; }
	public string RegexString { get; set; }
	public string SyncID { get; set; }
	public string Url { get; set; }
	public int[] RequiredRoles { get; set; }
}
public class GroupGiveawayChangedNotification{
	public long TimeStamp { get; set; }
	public GroupGiveawayChangeType ChangeType { get; set; }
	public GroupGiveawayNotification Giveaway { get; set; }
	public GroupMemberContract AffectedUser { get; set; }
	public GroupMemberContract Requestor { get; set; }
	public GroupGiveawayRollContract CurrentRoll { get; set; }
	public GroupGiveawayRollContract[] Rolls { get; set; }
}
public class GroupGiveawayNotification{
	public Guid GroupID { get; set; }
	public int GiveawayID { get; set; }
	public string Title { get; set; }
	public int CreatorID { get; set; }
	public int[] RequiredRoles { get; set; }
	public Dictionary<int, int>  RoleBonuses { get; set; }
	public int ResponseWindowSeconds { get; set; }
	public int SharingBonus { get; set; }
	public bool AllowRepeatWinners { get; set; }
	public bool AutoEnterActiveUsers { get; set; }
	public int RollsBeforeWinner { get; set; }
	public int[] AutoClaimRoles { get; set; }
	public int[] AutoEnterRoles { get; set; }
	public int[] IgnoredUsers { get; set; }
	public int Entries { get; set; }
	public int FakeRollsLeft { get; set; }
	public Dictionary<int, int>  TopShares { get; set; }
	public GroupGiveawayStatus Status { get; set; }
	public int CurrentRollNumber { get; set; }
	public bool IncludeOfflineMembers { get; set; }
}
public class GroupGiveawayRollContract{
	public int UserID { get; set; }
	public string Username { get; set; }
	public int RollNumber { get; set; }
	public GroupGiveawayRollStatus RollStatus { get; set; }
	public long Timestamp { get; set; }
	public int BestRoleID { get; set; }
	public string BestRoleName { get; set; }
	public GroupGiveawayWinnerValidStatus ValidStatus { get; set; }
}
public class GroupGiveawaySettingsNotification{
	public Guid GroupID { get; set; }
	public int[] RequiredRoles { get; set; }
	public Dictionary<int, int>  RoleBonuses { get; set; }
	public int ResponseWindowSeconds { get; set; }
	public int SharingBonus { get; set; }
	public GroupMemberContract[] IgnoredMembers { get; set; }
	public bool AutoEnterActiveUsers { get; set; }
	public int[] AutoEnterRoles { get; set; }
	public int[] AutoClaimRoles { get; set; }
	public int RollsBeforeWinner { get; set; }
	public bool AllowRepeatWinners { get; set; }
	public bool IncludeOfflineMembers { get; set; }
}
public class GroupInvitationNotification{
	public string InviteCode { get; set; }
	public int CreatorID { get; set; }
	public string CreatorName { get; set; }
	public Guid GroupID { get; set; }
	public GroupNotification Group { get; set; }
	public Guid ChannelID { get; set; }
	public GroupNotification Channel { get; set; }
	public long DateCreated { get; set; }
	public long? DateExpires { get; set; }
	public int? MaxUses { get; set; }
	public int TimesUsed { get; set; }
	public bool IsRedeemable { get; set; }
	public string InviteUrl { get; set; }
	public string AdminDescription { get; set; }
}
public class GroupMembershipNotification{
	public string Nickname { get; set; }
	public bool CanChangeNickname { get; set; }
	public int BestRole { get; set; }
	public int[] Roles { get; set; }
	public DateTime DateJoined { get; set; }
	public DateTime DateMessaged { get; set; }
	public DateTime DateRead { get; set; }
	public DateTime DateRemoved { get; set; }
	public int UnreadCount { get; set; }
	public bool IsFavorite { get; set; }
	public NotificationPreference NotificationPreference { get; set; }
	public string[] NotificationFilters { get; set; }
	public DateTime NotificationMuteDate { get; set; }
	public bool IsVoiceMuted { get; set; }
	public bool IsVoiceDeafened { get; set; }
	public bool IsBanned { get; set; }
}
public class GroupNotification{
	public string GroupTitle { get; set; }
	public Guid GroupID { get; set; }
	public int HomeRegionID { get; set; }
	public string HomeRegionKey { get; set; }
	public Guid ParentGroupID { get; set; }
	public Guid RootGroupID { get; set; }
	public string VoiceSessionCode { get; set; }
	public string MessageOfTheDay { get; set; }
	public GroupType GroupType { get; set; }
	public GroupSubType GroupSubtype { get; set; }
	public int DisplayOrder { get; set; }
	public bool MetaDataOnly { get; set; }
	public bool AllowTemporaryChildGroups { get; set; }
	public bool ForcePushToTalk { get; set; }
	public GroupStatus Status { get; set; }
	public bool IsDefaultChannel { get; set; }
	public GroupRoleNotification[] Roles { get; set; }
	public Dictionary<int, long>  RolePermissions { get; set; }
	public GroupMembershipNotification Membership { get; set; }
	public int MemberCount { get; set; }
	public GroupEmoticonNotification[] Emotes { get; set; }
	public GroupMemberContract[] Members { get; set; }
	public ChannelContract[] Channels { get; set; }
	public GroupMode GroupMode { get; set; }
	public bool IsPublic { get; set; }
	public string UrlPath { get; set; }
	public string UrlHost { get; set; }
	public bool ChatThrottleEnabled { get; set; }
	public int ChatThrottleSeconds { get; set; }
	public bool IsStreaming { get; set; }
	public ExternalCommunityPublicContract[] LinkedCommunities { get; set; }
	public int AfkTimerMins { get; set; }
	public long AvatarTimestamp { get; set; }
	public bool FlaggedAsInappropriate { get; set; }
	public int MembersOnline { get; set; }
	public bool HideNoAccess { get; set; }
	public bool HideCallMembersNoAccess { get; set; }
	public ExternalGuildContract[] LinkedGuilds { get; set; }
	public string ExternalChannelID { get; set; }
}
public class GroupMemberContract{
	public int UserID { get; set; }
	public string Username { get; set; }
	public string DisplayName { get; set; }
	public string Nickname { get; set; }
	public int BestRole { get; set; }
	public int[] Roles { get; set; }
	public long DateJoined { get; set; }
	public UserConnectionStatus ConnectionStatus { get; set; }
	public long DateLastSeen { get; set; }
	public long DateLastActive { get; set; }
	public long DateRemoved { get; set; }
	public bool IsActive { get; set; }
	public int CurrentGameID { get; set; }
	public bool IsVoiceMuted { get; set; }
	public bool IsVoiceDeafened { get; set; }
	public long AvatarTimestamp { get; set; }
	public ExternalAccountPublicContract[] ExternalAccounts { get; set; }
	public bool IsVerified { get; set; }
	public bool IsBanned { get; set; }
}
public class GroupPollChangedNotification{
	public GroupPollChangeType ChangeType { get; set; }
	public GroupPollNotification Poll { get; set; }
	public int RequestorUserID { get; set; }
}
public class GroupPollNotification{
	public Guid GroupID { get; set; }
	public int PollID { get; set; }
	public string Title { get; set; }
	public Dictionary<int, string>  Options { get; set; }
	public Dictionary<int, int>  Votes { get; set; }
	public long StartDate { get; set; }
	public int[] RequiredRoles { get; set; }
	public bool AllowMultipleSelections { get; set; }
	public GroupPollDisplayType DisplayType { get; set; }
	public GroupPollStatus Status { get; set; }
	public string PublicCode { get; set; }
	public string PublicUrl { get; set; }
	public bool AllowRevotes { get; set; }
	public GroupPollDuplicateMode DuplicationMode { get; set; }
	public long? MillisecondsLeft { get; set; }
}
public class GroupPreferenceNotification{
	public Guid GroupID { get; set; }
	public NotificationPreference Preference { get; set; }
	public bool IsFavorite { get; set; }
	public DateTime Timestamp { get; set; }
}
public class GroupPresenceNotification{
	public Guid GroupID { get; set; }
	public GroupPresenceContract[] Users { get; set; }
}
public class GroupPresenceContract{
	public int UserID { get; set; }
	public UserConnectionStatus ConnectionStatus { get; set; }
	public int GameID { get; set; }
	public long DateLastSeen { get; set; }
	public bool IsActive { get; set; }
}
public class GroupRoleNotification{
	public int RoleID { get; set; }
	public string Name { get; set; }
	public int Rank { get; set; }
	public int VanityColor { get; set; }
	public int VanityBadge { get; set; }
	public bool HasCustomVanityBadge { get; set; }
	public bool IsDefault { get; set; }
	public bool IsOwner { get; set; }
	public GroupRoleTag Tag { get; set; }
	public AccountType Source { get; set; }
	public bool IsHidden { get; set; }
	public string ExternalID { get; set; }
}
public class GroupPollSettingsNotification{
	public Guid GroupID { get; set; }
	public bool AllowMultipleSelections { get; set; }
	public GroupPollDisplayType DisplayType { get; set; }
	public int[] RequiredRoles { get; set; }
	public bool IsPublic { get; set; }
	public bool AllowRevotes { get; set; }
	public GroupPollDuplicateMode DuplicateMode { get; set; }
}
public class GroupSearchModelContract{
	public Guid GroupID { get; set; }
	public string GroupTitle { get; set; }
	public int OwnerUserID { get; set; }
	public string OwnerUsername { get; set; }
	public GroupSearchTag[] Tags { get; set; }
	public bool IsPublic { get; set; }
	public string Description { get; set; }
	public int MemberCount { get; set; }
	public int[] Games { get; set; }
	public bool MatchAllGames { get; set; }
	public bool IsStreaming { get; set; }
	public long StreamingTimestamp { get; set; }
	public GroupSubType Subtype { get; set; }
	public bool IsFeatured { get; set; }
	public long FeaturedTimestamp { get; set; }
	public bool FlaggedAsInappropriate { get; set; }
	public long CreationTimestamp { get; set; }
	public int SortRank { get; set; }
}
public class TwitchGroupSuggestionNotification{
	public Guid GroupID { get; set; }
	public string StreamID { get; set; }
	public string TwitchName { get; set; }
	public GroupRoleTag Role { get; set; }
}
public class GroupSuggestionsNotification{
	public TwitchGroupSuggestionNotification[] TwitchSuggestions { get; set; }
}
public class ExternalCommunityPublicContract{
	public string ExternalID { get; set; }
	public AccountType Type { get; set; }
	public string ExternalName { get; set; }
	public string ExternalDisplayName { get; set; }
	public int GameID { get; set; }
	public string ExternalGameName { get; set; }
	public string ExternalStatus { get; set; }
	public string ExternalUrl { get; set; }
	public bool IsLive { get; set; }
}
public class MutualFriendNotification{
	public int UserID { get; set; }
	public int[] MutualUserIDs { get; set; }
}
public class PlatformSearchContract{
	public Double Score { get; set; }
	public string SearchTerm { get; set; }
	public string Identity { get; set; }
	public string UniqueKey { get; set; }
	public int UserID { get; set; }
	public FriendPlatform Platform { get; set; }
	public FriendHintVisibility Visibility { get; set; }
	public int FriendCount { get; set; }
	public string Description { get; set; }
	public string AvatarUrl { get; set; }
	public FriendshipRequestAvailability FriendshipAvailability { get; set; }
}
public class GroupPrivateConversationContract{
	public int UserID { get; set; }
	public int OtherUserID { get; set; }
	public string OtherUsername { get; set; }
	public string OtherUserDisplayName { get; set; }
	public DateTime DateCreated { get; set; }
	public DateTime DateMessaged { get; set; }
	public DateTime DateRead { get; set; }
	public int UnreadCount { get; set; }
	public bool IsBlockedByThem { get; set; }
	public bool IsBlockedByMe { get; set; }
}
public class TemporaryAccessTokenContract{
	public Guid AccessToken { get; set; }
	public long DateExpires { get; set; }
}
public class UserBanStatusNotification{
	public int UserID { get; set; }
	public UserBanType Bans { get; set; }
}
public class UserClientSettingsNotification{
	public int UserID { get; set; }
	public long DateUpdated { get; set; }
	public string GlobalSettings { get; set; }
	public string DesktopSettings { get; set; }
	public string WebSettings { get; set; }
	public string MobileSettings { get; set; }
}
public class UserContract{
	public int UserID { get; set; }
	public string Username { get; set; }
	public UserConnectionStatus ConnectionStatus { get; set; }
	public string CustomStatusMessage { get; set; }
	public DateTime CustomStatusTimestamp { get; set; }
	public int FriendCount { get; set; }
	public int CurrentGameID { get; set; }
	public int CurrentGameState { get; set; }
	public string CurrentGameStatusMessage { get; set; }
	public DateTime CurrentGameTimestamp { get; set; }
	public PushNotificationPreference GroupMessagePushPreference { get; set; }
	public PushNotificationPreference FriendMessagePushPreference { get; set; }
	public bool FriendRequestPushEnabled { get; set; }
	public bool? MentionsPushEnabled { get; set; }
	public long AvatarTimestamp { get; set; }
	public string DisplayName { get; set; }
	public ExternalCommunityPublicContract WatchingChannel { get; set; }
	public bool IsBroadcasting { get; set; }
	public int BroadcastingGameID { get; set; }
	public UserPrivacySettingsContract PrivacySettings { get; set; }
	public int ConfirmedFriendSyncCount { get; set; }
	public int DeclinedFriendSyncCount { get; set; }
	public bool IsPartner { get; set; }
	public bool HasSeenPartnerUpsell { get; set; }
}
public class FriendshipContract{
	public FriendshipStatus Status { get; set; }
	public int OtherUserID { get; set; }
	public string OtherUsername { get; set; }
	public string OtherDisplayName { get; set; }
	public string OtherUserNickname { get; set; }
	public int OtherUserRegionID { get; set; }
	public UserConnectionStatus OtherUserConnectionStatus { get; set; }
	public string InvitationMessage { get; set; }
	public bool IsFavorite { get; set; }
	public string OtherUserStatusMessage { get; set; }
	public int OtherUserGameID { get; set; }
	public string OtherUserGameStatusMessage { get; set; }
	public int OtherUserGameState { get; set; }
	public DateTime OtherUserGameTimestamp { get; set; }
	public string OtherUserAvatarUrl { get; set; }
	public DateTime DateConfirmed { get; set; }
	public DateTime DateMessaged { get; set; }
	public DateTime DateRead { get; set; }
	public int UnreadCount { get; set; }
	public int MutualFriendCount { get; set; }
	public long OtherUserConnectionStatusTimestamp { get; set; }
	public long RequestedTimestamp { get; set; }
	public long AvatarTimestamp { get; set; }
	public ClientCapability Capabilities { get; set; }
	public string OtherWatchingChannelID { get; set; }
	public string OtherWatchingChannelName { get; set; }
	public string OtherWatchingChannelUrl { get; set; }
	public int OtherBroadcastingGameID { get; set; }
	public bool OtherIsBroadcasting { get; set; }
	public string OtherUserTwitchID { get; set; }
}
public class FriendshipRemovedNotification{
	public int FriendID { get; set; }
}
public class HealthCheckRequest{
	public string ApiKey { get; set; }
	public string MachineName { get; set; }
}
public enum DeliveryStatus {
	UnknownUser = 0,
	Error = 1,
	Forbidden = 2,
	FriendOffline = 3,
	Successful = 4,
	Throttled = 5,
}
public class UserChangeNotification{
	public UserContract User { get; set; }
}
public class UsernameSearchContract{
	public Double Score { get; set; }
	public string Username { get; set; }
	public string DisplayName { get; set; }
	public int UserID { get; set; }
	public int FriendCount { get; set; }
	public string AvatarUrl { get; set; }
	public FriendshipRequestAvailability FriendshipAvailability { get; set; }
	public bool IsMerged { get; set; }
}
public class UserPrivacySettingsContract{
	public PrivateMessagePrivacy PrivateMessagePrivacy { get; set; }
	public FriendRequestPrivacy FriendRequestPrivacy { get; set; }
	public ShareActivityPrivacy ShareActivityPrivacy { get; set; }
}
public class UserProfileNotification{
	public int UserID { get; set; }
	public string Username { get; set; }
	public string DisplayName { get; set; }
	public string Name { get; set; }
	public string City { get; set; }
	public string State { get; set; }
	public string CountryCode { get; set; }
	public string AboutMe { get; set; }
	public int FriendCount { get; set; }
	public int LastGameID { get; set; }
	public FriendHintContract[] Identities { get; set; }
	public MutualFriendNotification[] MutualFriends { get; set; }
	public Guid[] MutualGroupIDs { get; set; }
}
public class JoinRequest{
	public int UserID { get; set; }
	public string MachineKey { get; set; }
	public string SessionID { get; set; }
	public UserConnectionStatus Status { get; set; }
	public string ClientVersion { get; set; }
	public Byte[] PublicKey { get; set; }
	public int CipherAlgorithm { get; set; }
	public int CipherStrength { get; set; }
}
public enum JoinStatus {
	Successful = 1,
	FailedUnhandledException = 2,
	InvalidClientVersion = 3,
	InvalidSessionID = 4,
	Timeout = 5,
	Throttled = 6,
}
public class JoinResponse{
	public JoinStatus Status { get; set; }
	public DateTime ServerTime { get; set; }
	public Byte[] EncryptedSessionKey { get; set; }
	public UserConnectionStatus ConnectionStatus { get; set; }
}

}
