using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;
namespace Curse.ServiceClients.Contracts
{
public class ChangeCommunitySettingsRequest{
	public bool SyncEmoticons { get; set; }
	public bool SyncEvents { get; set; }
	public SyncedMemberGracePeriodAction GracePeriodAction { get; set; }
	public int GracePeriodDays { get; set; }
}
public class SyncedCommunityMembershipResponse{
	public SyncedServerMembership[] TwitchSuggestions { get; set; }
	public SyncedServerMembership[] YouTubeSuggestions { get; set; }
}
public class SyncedServerMembership{
	public Guid GroupID { get; set; }
	public string GroupTitle { get; set; }
	public int GroupMemberCount { get; set; }
	public bool IsPublic { get; set; }
	public string ExternalCommunityID { get; set; }
	public string ExternalCommunityName { get; set; }
	public AccountType ExternalCommunityType { get; set; }
	public GroupRoleTag RoleTag { get; set; }
	public bool IsMember { get; set; }
}
public class PremiumMemberSearchResponse{
	public long Active { get; set; }
	public long Inactive { get; set; }
	public ExternalCommunityMemberContract[] Results { get; set; }
}
public class FollowTwitchChannelResponse{
	public string[] SuccessfulAccounts { get; set; }
	public string[] UnsuccessfulAccounts { get; set; }
}
public class LinkExternalAccountRequest{
	public string SuccessRedirectUrl { get; set; }
	public string FailureRedirectUrl { get; set; }
	public bool? ForceVerify { get; set; }
	public int? GameRegion { get; set; }
}
public class AccountResyncResponse{
	public AccountResyncStatus Status { get; set; }
	public long RetryAfterMilliseconds { get; set; }
}
public enum AccountResyncStatus {
	Error = 0,
	Success = 1,
	Throttled = 2,
}
public class LinkGuildRequest{
	public SyncedGuildRoleName[] Roles { get; set; }
}
public class SyncedGuildRoleName{
	public GroupRoleTag Tag { get; set; }
	public string Name { get; set; }
}
public class GuildDetailsContract{
	public ExternalGuildContract GuildInfo { get; set; }
	public GuildRankDetailsContract[] Ranks { get; set; }
}
public class GuildRankDetailsContract{
	public GroupRoleTag Rank { get; set; }
	public GuildMemberDetailsContract[] MyMembers { get; set; }
	public GuildMemberDetailsContract[] SampleMembers { get; set; }
}
public class GuildMemberDetailsContract{
	public string GameServer { get; set; }
	public string Name { get; set; }
}

}
