﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.ServiceClients
{
    internal class SimpleTimer : IDisposable
    {
        private readonly Stopwatch _sw;
        private readonly string _description;

        public SimpleTimer(string category, string description)
        {
#if TIMERS
            _sw = Stopwatch.StartNew();
            _description = "[" + category + "]" + description;
#endif
        }

        public void Dispose()
        {
#if TIMERS
            _sw.Stop();
            Logger.Debug(_description + ": " + _sw.ElapsedMilliseconds + " ms");
#endif
        }
    }
}
